/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunk_serializer.common;

import com.ishland.c2me.base.mixin.access.IBelowZeroRetrogen;
import com.ishland.c2me.base.mixin.access.IState;
import com.ishland.c2me.base.mixin.access.IStructurePiece;
import com.ishland.c2me.base.mixin.access.IStructureStart;
import com.ishland.c2me.rewrites.chunk_serializer.common.ChunkStatusAccessor;
import com.ishland.c2me.rewrites.chunk_serializer.common.HeightMapTypeAccessor;
import com.ishland.c2me.rewrites.chunk_serializer.common.NbtWriter;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.LongStream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11897;
import net.minecraft.class_155;
import net.minecraft.class_1923;
import net.minecraft.class_1953;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2516;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2808;
import net.minecraft.class_2841;
import net.minecraft.class_2843;
import net.minecraft.class_2852;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_6624;
import net.minecraft.class_6625;
import net.minecraft.class_6746;
import net.minecraft.class_6749;
import net.minecraft.class_6759;
import net.minecraft.class_6760;
import net.minecraft.class_6880;
import net.minecraft.class_7522;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Contract;

public final class ChunkDataSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final byte[] STRING_DATA_VERSION = NbtWriter.getAsciiStringBytes("DataVersion");
    private static final byte[] STRING_X_POS = NbtWriter.getAsciiStringBytes("xPos");
    private static final byte[] STRING_Y_POS = NbtWriter.getAsciiStringBytes("yPos");
    private static final byte[] STRING_Z_POS = NbtWriter.getAsciiStringBytes("zPos");
    private static final byte[] STRING_LAST_UPDATE = NbtWriter.getAsciiStringBytes("LastUpdate");
    private static final byte[] STRING_INHABITED_TIME = NbtWriter.getAsciiStringBytes("InhabitedTime");
    private static final byte[] STRING_STATUS = NbtWriter.getAsciiStringBytes("Status");
    private static final byte[] STRING_BLENDING_DATA = NbtWriter.getAsciiStringBytes("blending_data");
    private static final byte[] STRING_BELOW_ZERO_RETROGEN = NbtWriter.getAsciiStringBytes("below_zero_retrogen");
    private static final byte[] STRING_UPGRADE_DATA = NbtWriter.getAsciiStringBytes("UpgradeData");
    private static final byte[] STRING_IS_LIGHT_ON = NbtWriter.getAsciiStringBytes("isLightOn");
    private static final byte[] STRING_BLOCK_ENTITIES = NbtWriter.getAsciiStringBytes("block_entities");
    private static final byte[] STRING_PALETTE = NbtWriter.getAsciiStringBytes("palette");
    private static final byte[] STRING_DATA = NbtWriter.getAsciiStringBytes("data");
    private static final byte[] STRING_SECTIONS = NbtWriter.getAsciiStringBytes("sections");
    private static final byte[] STRING_BLOCK_STATES = NbtWriter.getAsciiStringBytes("block_states");
    private static final byte[] STRING_BIOMES = NbtWriter.getAsciiStringBytes("biomes");
    private static final byte[] STRING_BLOCK_LIGHT = NbtWriter.getAsciiStringBytes("BlockLight");
    private static final byte[] STRING_SKY_LIGHT = NbtWriter.getAsciiStringBytes("SkyLight");
    private static final byte[] STRING_OLD_NOISE = NbtWriter.getAsciiStringBytes("old_noise");
    private static final byte[] STRING_HEIGHTS = NbtWriter.getAsciiStringBytes("heights");
    private static final byte[] STRING_MIN_SECTION = NbtWriter.getAsciiStringBytes("min_section");
    private static final byte[] STRING_MAX_SECTION = NbtWriter.getAsciiStringBytes("max_section");
    private static final byte[] STRING_TARGET_STATUS = NbtWriter.getAsciiStringBytes("target_status");
    private static final byte[] STRING_MISSING_BEDROCK = NbtWriter.getAsciiStringBytes("missing_bedrock");
    private static final byte[] STRING_INDICES = NbtWriter.getAsciiStringBytes("Indices");
    private static final byte[] STRING_SIDES = NbtWriter.getAsciiStringBytes("Sides");
    private static final byte[] STRING_ENTITIES = NbtWriter.getAsciiStringBytes("entities");
    private static final byte[] STRING_LIGHTS = NbtWriter.getAsciiStringBytes("Lights");
    private static final byte[] STRING_CARVING_MASK = NbtWriter.getAsciiStringBytes("carving_mask");
    private static final byte[] STRING_HEIGHTMAPS = NbtWriter.getAsciiStringBytes("Heightmaps");
    private static final byte[] STRING_POST_PROCESSING = NbtWriter.getAsciiStringBytes("PostProcessing");
    private static final byte[] STRING_BLOCK_TICKS = NbtWriter.getAsciiStringBytes("block_ticks");
    private static final byte[] STRING_FLUID_TICKS = NbtWriter.getAsciiStringBytes("fluid_ticks");
    private static final byte[] STRING_STRUCTURES = NbtWriter.getAsciiStringBytes("structures");
    private static final byte[] STRING_STARTS = NbtWriter.getAsciiStringBytes("starts");
    private static final byte[] STRING_BIG_REFERENCES = NbtWriter.getAsciiStringBytes("References");
    private static final byte[] STRING_ID = NbtWriter.getAsciiStringBytes("id");
    private static final byte[] STRING_CHUNK_X = NbtWriter.getAsciiStringBytes("ChunkX");
    private static final byte[] STRING_CHUNK_Z = NbtWriter.getAsciiStringBytes("ChunkZ");
    private static final byte[] STRING_SMALL_REFERENCES = NbtWriter.getAsciiStringBytes("references");
    private static final byte[] STRING_CHILDREN = NbtWriter.getAsciiStringBytes("Children");
    private static final byte[] STRING_INVALID = NbtWriter.getAsciiStringBytes("INVALID");
    private static final byte[] STRING_BB = NbtWriter.getAsciiStringBytes("BB");
    private static final byte[] STRING_O = NbtWriter.getAsciiStringBytes("O");
    private static final byte[] STRING_GD = NbtWriter.getAsciiStringBytes("GD");
    private static final byte[] STRING_NAME = NbtWriter.getAsciiStringBytes("Name");
    private static final byte[] STRING_PROPERTIES = NbtWriter.getAsciiStringBytes("Properties");
    private static final byte[] STRING_CHAR_BIG_Y = NbtWriter.getAsciiStringBytes("Y");
    private static final byte[] STRING_CHAR_SMALL_I = NbtWriter.getAsciiStringBytes("i");
    private static final byte[] STRING_CHAR_SMALL_P = NbtWriter.getAsciiStringBytes("p");
    private static final byte[] STRING_CHAR_SMALL_T = NbtWriter.getAsciiStringBytes("t");
    private static final byte[] STRING_CHAR_SMALL_X = NbtWriter.getAsciiStringBytes("x");
    private static final byte[] STRING_CHAR_SMALL_Y = NbtWriter.getAsciiStringBytes("y");
    private static final byte[] STRING_CHAR_SMALL_Z = NbtWriter.getAsciiStringBytes("z");
    private static final byte[] STRING_C2ME = NbtWriter.getAsciiStringBytes("C2ME");
    private static final byte[] STRING_KROPPEB = NbtWriter.getAsciiStringBytes("Kroppeb was here :); Version: 0.3.0");
    private static final byte[] STRING_C2ME_MARK_A = NbtWriter.getAsciiStringBytes("C2ME::MarkA");
    private static final byte[] STRING_MARKER_FLUID_PROTO = NbtWriter.getAsciiStringBytes("fluid:proto");
    private static final byte[] STRING_MARKER_FLUID_FULL = NbtWriter.getAsciiStringBytes("fluid:full");
    private static final byte[] STRING_MARKER_FLUID_FALLBACK = NbtWriter.getAsciiStringBytes("fluid:fallback");
    private static final byte[] STRING_BLOCKLIGHT_STATE_TAG = NbtWriter.getAsciiStringBytes("starlight.blocklight_state");
    private static final byte[] STRING_SKYLIGHT_STATE_TAG = NbtWriter.getAsciiStringBytes("starlight.skylight_state");
    private static final byte[] STRING_STARLIGHT_VERSION_TAG = NbtWriter.getAsciiStringBytes("starlight.light_version");
    private static final int STARLIGHT_LIGHT_VERSION = 8;
    private static final boolean STARLIGHT = FabricLoader.getInstance().isModLoaded("starlight");

    public static void write(class_2852 serializable, NbtWriter writer) {
        class_2843 upgradeData;
        class_6746 belowZeroRetrogen;
        class_1923 chunkPos = serializable.comp_2946();
        writer.putString(STRING_C2ME, STRING_KROPPEB);
        writer.putInt(STRING_DATA_VERSION, class_155.method_16673().comp_4026().comp_4038());
        writer.putInt(STRING_X_POS, chunkPos.field_9181);
        writer.putInt(STRING_Y_POS, serializable.comp_2947());
        writer.putInt(STRING_Z_POS, chunkPos.field_9180);
        writer.putLong(STRING_LAST_UPDATE, serializable.comp_2948());
        writer.putLong(STRING_INHABITED_TIME, serializable.comp_2949());
        writer.putString(STRING_STATUS, ((ChunkStatusAccessor)serializable.comp_2950()).getIdBytes());
        class_6749.class_9899 blendingData = serializable.comp_2951();
        if (blendingData != null) {
            writer.startCompound(STRING_BLENDING_DATA);
            ChunkDataSerializer.writeBlendingData(writer, blendingData);
            writer.finishCompound();
        }
        if ((belowZeroRetrogen = serializable.comp_2952()) != null) {
            writer.startCompound(STRING_BELOW_ZERO_RETROGEN);
            ChunkDataSerializer.writeBelowZeroRetrogen(writer, (IBelowZeroRetrogen)belowZeroRetrogen);
            writer.finishCompound();
        }
        if (!(upgradeData = serializable.comp_2953()).method_12349()) {
            writer.putElement(STRING_UPGRADE_DATA, (class_2520)upgradeData.method_12350());
        }
        List sectionData = serializable.comp_2959();
        class_11897 containerFactory = serializable.comp_4792();
        ChunkDataSerializer.checkLightFlag(serializable.comp_2958(), writer);
        ChunkDataSerializer.writeSectionData(writer, chunkPos, sectionData, containerFactory);
        writer.startFixedList(STRING_BLOCK_ENTITIES, serializable.comp_2961().size(), (byte)10);
        for (class_2487 blockEntity : serializable.comp_2961()) {
            writer.putElementEntry((class_2520)blockEntity);
        }
        if (serializable.comp_2950().method_12164() == class_2808.field_12808) {
            List entities = serializable.comp_2960();
            writer.startFixedList(STRING_ENTITIES, entities.size(), (byte)10);
            for (class_2487 class_24872 : entities) {
                writer.putElementEntry((class_2520)class_24872);
            }
            if (serializable.comp_2954() != null) {
                writer.putLongArray(STRING_CARVING_MASK, serializable.comp_2954());
            }
        }
        ChunkDataSerializer.serializeTicks(writer, serializable.comp_2956());
        ShortList[] postProcessingLists = serializable.comp_2957();
        ChunkDataSerializer.putShortListArray(postProcessingLists, writer, STRING_POST_PROCESSING);
        writer.startCompound(STRING_HEIGHTMAPS);
        for (Map.Entry entry : serializable.comp_2955().entrySet()) {
            writer.putLongArray(((HeightMapTypeAccessor)entry.getKey()).getNameBytes(), (long[])entry.getValue());
        }
        writer.finishCompound();
        writer.getVisitor().visit(STRING_STRUCTURES, (class_2520)serializable.comp_2962());
    }

    private static void checkLightFlag(boolean lightCorrect, NbtWriter writer) {
        if (STARLIGHT) {
            if (lightCorrect) {
                writer.putBoolean(STRING_IS_LIGHT_ON, false);
            }
        } else if (lightCorrect) {
            writer.putBoolean(STRING_IS_LIGHT_ON, true);
        }
    }

    private static void putShortListArray(ShortList[] data, NbtWriter writer, byte[] name) {
        writer.startFixedList(name, data.length, (byte)9);
        for (ShortList shortList : data) {
            if (shortList != null) {
                writer.startFixedListEntry(shortList.size(), (byte)2);
                ShortListIterator iter = shortList.iterator();
                while (iter.hasNext()) {
                    writer.putShortEntry(iter.nextShort());
                }
                continue;
            }
            writer.startFixedListEntry(0, (byte)2);
        }
    }

    private static void writeSectionData(NbtWriter writer, class_1923 chunkPos, List<class_2852.class_9898> sectionData, class_11897 containerFactory) {
        ChunkDataSerializer.writeSectionDataVanilla(writer, chunkPos, sectionData, containerFactory);
    }

    private static void writeSectionDataVanilla(NbtWriter writer, class_1923 chunkPos, List<class_2852.class_9898> sectionData, class_11897 containerFactory) {
        long sectionsStart = writer.startList(STRING_SECTIONS, (byte)10);
        int sectionCount = 0;
        int sectionDataSize = sectionData.size();
        for (int __i = 0; __i < sectionDataSize; ++__i) {
            class_2852.class_9898 sectionDatum = sectionData.get(__i);
            boolean hasInner = false;
            if (sectionDatum.comp_2964() != null) {
                if (!hasInner) {
                    hasInner = true;
                    writer.compoundEntryStart();
                }
                ChunkDataSerializer.writeBlockStates(writer, (class_2841<class_2680>)sectionDatum.comp_2964().method_12265(), containerFactory);
                ChunkDataSerializer.writeBiomes(writer, (class_7522<class_6880<class_1959>>)sectionDatum.comp_2964().method_38294(), containerFactory);
            }
            if (sectionDatum.comp_2965() != null) {
                if (!hasInner) {
                    hasInner = true;
                    writer.compoundEntryStart();
                }
                writer.putByteArray(STRING_BLOCK_LIGHT, sectionDatum.comp_2965().method_12137());
            }
            if (sectionDatum.comp_2966() != null) {
                if (!hasInner) {
                    hasInner = true;
                    writer.compoundEntryStart();
                }
                writer.putByteArray(STRING_SKY_LIGHT, sectionDatum.comp_2966().method_12137());
            }
            if (!hasInner) continue;
            writer.putByte(STRING_CHAR_BIG_Y, (byte)sectionDatum.comp_2963());
            writer.finishCompound();
            ++sectionCount;
        }
        writer.finishList(sectionsStart, sectionCount);
    }

    private static void writeBlockStates(NbtWriter writer, class_2841<class_2680> blockStateContainer, class_11897 containerFactory) {
        writer.startCompound(STRING_BLOCK_STATES);
        class_7522.class_6562 data = blockStateContainer.method_44345(containerFactory.comp_4785());
        List paletteEntries = data.comp_75();
        writer.startFixedList(STRING_PALETTE, paletteEntries.size(), (byte)10);
        for (class_2680 paletteEntry : paletteEntries) {
            writer.compoundEntryStart();
            writer.putRegistry(STRING_NAME, class_7923.field_41175, paletteEntry.method_26204());
            if (!paletteEntry.method_11656().isEmpty()) {
                writer.putElement(STRING_PROPERTIES, (class_2520)((IState)paletteEntry).getCodec().codec().encodeStart((DynamicOps)class_2509.field_11560, (Object)paletteEntry).getOrThrow(class_2852.class_9314::new));
            }
            writer.finishCompound();
        }
        Optional storage = data.comp_76();
        if (storage.isPresent()) {
            writer.putLongArray(STRING_DATA, ((LongStream)storage.get()).toArray());
        }
        writer.finishCompound();
    }

    private static void writeBiomes(NbtWriter writer, class_7522<class_6880<class_1959>> biomeContainer, class_11897 containerFactory) {
        writer.startCompound(STRING_BIOMES);
        class_7522.class_6562 data = biomeContainer.method_44345(containerFactory.comp_4788());
        List paletteEntries = data.comp_75();
        writer.startFixedList(STRING_PALETTE, paletteEntries.size(), (byte)8);
        for (class_6880 paletteEntry : paletteEntries) {
            writer.putRegistryEntry(paletteEntry);
        }
        Optional storage = data.comp_76();
        if (storage.isPresent()) {
            writer.putLongArray(STRING_DATA, (LongStream)storage.get());
        }
        writer.finishCompound();
    }

    private static void writeBlendingData(NbtWriter writer, class_6749.class_9899 blendingData) {
        writer.putInt(STRING_MIN_SECTION, blendingData.comp_2969());
        writer.putInt(STRING_MAX_SECTION, blendingData.comp_2970());
        double[] heights = blendingData.comp_2971().orElse(null);
        if (heights != null) {
            writer.putDoubles(STRING_HEIGHTS, heights);
        }
    }

    private static void writeBelowZeroRetrogen(NbtWriter writer, IBelowZeroRetrogen belowZeroRetrogen) {
        writer.putRegistry(STRING_TARGET_STATUS, class_7923.field_41184, belowZeroRetrogen.invokeGetTargetStatus());
        BitSet missingBedrock = belowZeroRetrogen.getMissingBedrock();
        if (!missingBedrock.isEmpty()) {
            writer.putLongArray(STRING_MISSING_BEDROCK, missingBedrock.toLongArray());
        }
    }

    @Deprecated
    public static class_2499 toNbt(ShortList[] lists) {
        class_2499 nbtList = new class_2499();
        for (ShortList shortList : lists) {
            class_2499 nbtList2 = new class_2499();
            if (shortList != null) {
                ShortListIterator iter = shortList.iterator();
                while (iter.hasNext()) {
                    nbtList2.add((Object)class_2516.method_23254((short)iter.nextShort()));
                }
            }
            nbtList.add((Object)nbtList2);
        }
        return nbtList;
    }

    private static void serializeTicks(NbtWriter writer, class_2791.class_6745 tickSchedulers) {
        ChunkDataSerializer.writeTicks(writer, tickSchedulers.comp_239(), class_7923.field_41175, STRING_BLOCK_TICKS);
        ChunkDataSerializer.writeTicks(writer, tickSchedulers.comp_240(), class_7923.field_41173, STRING_FLUID_TICKS);
    }

    private static <T> void writeTicks(NbtWriter writer, List<class_6759<T>> scheduledTicks, class_7922<T> reg, byte[] key) {
        writer.startFixedList(key, scheduledTicks.size(), (byte)10);
        for (class_6759<T> scheduledTick : scheduledTicks) {
            ChunkDataSerializer.writeTick(writer, scheduledTick, reg);
        }
    }

    private static <T> void writeOrderedTick(NbtWriter writer, class_6760<T> orderedTick, long time, class_2378<T> reg) {
        writer.compoundEntryStart();
        writer.putRegistry(STRING_CHAR_SMALL_I, reg, orderedTick.comp_252());
        ChunkDataSerializer.writeGenericTickData(writer, orderedTick.comp_253(), (int)(orderedTick.comp_254() - time), orderedTick.comp_255());
        writer.finishCompound();
    }

    private static <T> void writeTick(NbtWriter writer, class_6759<T> scheduledTick, class_2378<T> reg) {
        writer.compoundEntryStart();
        writer.putRegistry(STRING_CHAR_SMALL_I, reg, scheduledTick.comp_248());
        ChunkDataSerializer.writeGenericTickData(writer, scheduledTick);
        writer.finishCompound();
    }

    private static void writeGenericTickData(NbtWriter writer, class_6759<?> scheduledTick) {
        ChunkDataSerializer.writeGenericTickData(writer, scheduledTick.comp_249(), scheduledTick.comp_250(), scheduledTick.comp_251());
    }

    private static void writeGenericTickData(NbtWriter writer, class_2338 pos, int delay, class_1953 priority) {
        writer.putInt(STRING_CHAR_SMALL_X, pos.method_10263());
        writer.putInt(STRING_CHAR_SMALL_Y, pos.method_10264());
        writer.putInt(STRING_CHAR_SMALL_Z, pos.method_10260());
        writer.putInt(STRING_CHAR_SMALL_T, delay);
        writer.putInt(STRING_CHAR_SMALL_P, priority.method_8681());
    }

    private static void writeStructures(NbtWriter writer, class_6625 context, class_1923 pos, Map<class_3195, class_3449> starts, Map<class_3195, LongSet> references) {
        writer.startCompound(STRING_STRUCTURES);
        writer.startCompound(STRING_STARTS);
        class_2378 configuredStructureFeatureRegistry = context.comp_134().method_30530(class_7924.field_41246);
        for (Map.Entry<class_3195, class_3449> entry : starts.entrySet()) {
            writer.startCompound(NbtWriter.getNameBytesFromRegistry(configuredStructureFeatureRegistry, entry.getKey()));
            IStructureStart value = (IStructureStart)ChunkDataSerializer.cast(entry.getValue());
            ChunkDataSerializer.writeStructureStart(writer, value, context, pos);
            writer.finishCompound();
        }
        writer.finishCompound();
        writer.startCompound(STRING_BIG_REFERENCES);
        for (Map.Entry<class_3195, class_3449> entry : references.entrySet()) {
            if (((LongSet)entry.getValue()).isEmpty()) continue;
            writer.putLongArray(NbtWriter.getNameBytesFromRegistry(configuredStructureFeatureRegistry, entry.getKey()), (LongCollection)entry.getValue());
        }
        writer.finishCompound();
        writer.finishCompound();
    }

    private static void writeStructureStart(NbtWriter writer, IStructureStart structureStart, class_6625 context, class_1923 pos) {
        class_6624 children = structureStart.getChildren();
        if (children.method_38708()) {
            writer.putString(STRING_ID, STRING_INVALID);
            return;
        }
        writer.putRegistry(STRING_ID, context.comp_134().method_30530(class_7924.field_41246), structureStart.getStructure());
        writer.putInt(STRING_CHUNK_X, pos.field_9181);
        writer.putInt(STRING_CHUNK_Z, pos.field_9180);
        writer.putInt(STRING_SMALL_REFERENCES, structureStart.getReferences());
        writer.startFixedList(STRING_CHILDREN, children.comp_132().size(), (byte)10);
        for (class_3443 piece : children.comp_132()) {
            writer.putElementEntry((class_2520)piece.method_14946(context));
        }
    }

    private static void writeStructurePiece(NbtWriter writer, IStructurePiece structurePiece, class_6625 context) {
        class_2350 direction;
        writer.compoundEntryStart();
        writer.putRegistry(STRING_ID, class_7923.field_41146, structurePiece.getType());
        Optional optional = class_3341.field_29325.encodeStart((DynamicOps)class_2509.field_11560, (Object)structurePiece.getBoundingBox()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0));
        if (optional.isPresent()) {
            writer.putElement(STRING_BB, (class_2520)optional.get());
        }
        writer.putInt(STRING_O, (direction = structurePiece.getFacing()) == null ? -1 : direction.method_10161());
        writer.putInt(STRING_GD, structurePiece.getChainLength());
        writer.finishCompound();
    }

    @Contract(value="null -> null; !null -> !null")
    private static <T> T cast(Object entry) {
        return (T)entry;
    }
}

