/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common;

import com.llamalad7.mixinextras.MixinExtrasBootstrap;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ModuleMixinPlugin
implements IMixinConfigPlugin {
    static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME Modules Manager");
    protected boolean isEnabled = true;

    public void onLoad(String mixinPackage) {
        MixinExtrasBootstrap.init();
        LOGGER.info("Initializing {}", (Object)mixinPackage);
        String[] split = mixinPackage.split("\\.");
        String targetClass = String.join((CharSequence)".", Arrays.copyOf(split, split.length - 1)) + ".ModuleEntryPoint";
        try {
            Class<?> entryPoint = Class.forName(targetClass);
            try {
                Field enabled = entryPoint.getDeclaredField("enabled");
                enabled.setAccessible(true);
                this.isEnabled = (Boolean)enabled.get(null);
            }
            catch (Throwable t) {
                LOGGER.warn("Unable to detect enabled state for module entrypoint: {}", (Object)targetClass, (Object)t);
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Error loading module entrypoint: {}", (Object)targetClass, (Object)t);
        }
        if (!this.isEnabled) {
            LOGGER.info("Disabling {}", (Object)mixinPackage);
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return this.isEnabled;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

