/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class FilteringIterable<T>
implements Iterable<T> {
    private final Iterable<T> delegate;
    private final Predicate<T> predicate;

    public FilteringIterable(Iterable<T> delegate, Predicate<T> predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new FilteringIterator();
    }

    private class FilteringIterator
    implements Iterator<T> {
        private final Iterator<T> iterator;
        private T next;

        private FilteringIterator() {
            this.iterator = FilteringIterable.this.delegate.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.calculateNext();
        }

        @Override
        public T next() {
            if (this.calculateNext()) {
                Object object = this.next;
                this.next = null;
                return object;
            }
            throw new NoSuchElementException();
        }

        private boolean calculateNext() {
            if (this.next != null) {
                return true;
            }
            while (this.iterator.hasNext()) {
                Object object = this.iterator.next();
                if (!FilteringIterable.this.predicate.test(object)) continue;
                this.next = object;
                return true;
            }
            return false;
        }
    }
}

