/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common.util;

import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class TimeUtil {
    public static String formatElapsedTime(long nanos) {
        if (nanos < 0L) {
            return nanos + " ns";
        }
        if (nanos == 0L) {
            return "0 ns";
        }
        TimeUnit unit = TimeUtil.chooseUnit(nanos);
        double value = (double)nanos / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
        return TimeUtil.formatCompact4Digits(value) + " " + TimeUtil.abbreviate(unit);
    }

    static String formatCompact4Digits(double value) {
        return String.format(Locale.ROOT, "%.4g", value);
    }

    private static TimeUnit chooseUnit(long nanos) {
        if (TimeUnit.DAYS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.DAYS;
        }
        if (TimeUnit.HOURS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.HOURS;
        }
        if (TimeUnit.MINUTES.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MINUTES;
        }
        if (TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }

    private static String abbreviate(TimeUnit unit) {
        return switch (unit) {
            case TimeUnit.NANOSECONDS -> "ns";
            case TimeUnit.MICROSECONDS -> "\u03bcs";
            case TimeUnit.MILLISECONDS -> "ms";
            case TimeUnit.SECONDS -> "s";
            case TimeUnit.MINUTES -> "min";
            case TimeUnit.HOURS -> "h";
            case TimeUnit.DAYS -> "d";
            default -> throw new AssertionError();
        };
    }
}

