/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.flowsched.scheduler;

import com.ishland.flowsched.scheduler.ItemStatus;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class ItemTicket<K, V, Ctx> {
    private static final AtomicReferenceFieldUpdater<ItemTicket, Runnable> CALLBACK_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ItemTicket.class, Runnable.class, "callback");
    private final TicketType type;
    private final Object source;
    private final ItemStatus<K, V, Ctx> targetStatus;
    private volatile Runnable callback = null;

    public ItemTicket(TicketType type, Object source, ItemStatus<K, V, Ctx> targetStatus, Runnable callback) {
        this.type = Objects.requireNonNull(type);
        this.source = Objects.requireNonNull(source);
        this.targetStatus = Objects.requireNonNull(targetStatus);
        this.callback = callback;
    }

    public Object getSource() {
        return this.source;
    }

    public ItemStatus<K, V, Ctx> getTargetStatus() {
        return this.targetStatus;
    }

    public TicketType getType() {
        return this.type;
    }

    public void consumeCallback() {
        Runnable callback = CALLBACK_UPDATER.getAndSet(this, null);
        if (callback != null) {
            try {
                callback.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemTicket that = (ItemTicket)o;
        return this.type == that.type && Objects.equals(this.source, that.source) && Objects.equals(this.targetStatus, that.targetStatus);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.targetStatus.hashCode();
        return result;
    }

    public static class TicketType {
        public static TicketType DEPENDENCY = new TicketType("flowsched:dependency");
        public static TicketType EXTERNAL = new TicketType("flowsched:external");
        private final String description;

        public TicketType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

