/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.fixes.worldgen.threading_issues.asm;

import com.ishland.c2me.fixes.worldgen.threading_issues.asm.MakeVolatile;
import java.util.Collection;
import java.util.stream.Stream;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASMTransformerMakeVolatile {
    static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME (c2me-fixes-worldgen-threading-issues) ASM Transformer");

    public static void transform(ClassNode classNode) {
        classNode.fields.stream().filter(fieldNode -> Stream.concat(Stream.ofNullable(fieldNode.visibleAnnotations), Stream.ofNullable(fieldNode.invisibleAnnotations)).flatMap(Collection::stream).anyMatch(annotationNode -> Type.getDescriptor(MakeVolatile.class).equals(annotationNode.desc))).forEach(fieldNode -> {
            LOGGER.debug("Making field L{};{}:{} volatile", new Object[]{classNode.name, fieldNode.name, fieldNode.desc});
            fieldNode.access |= 0x40;
        });
    }

    private record KeyValue<K, V>(K key, V value) {
    }
}

