/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunk_serializer.common.utils;

import com.ishland.c2me.rewrites.chunk_serializer.common.utils.AccessControllerUtils;
import com.ishland.c2me.rewrites.chunk_serializer.common.utils.UnsafeUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectionUtils {
    public static ConcurrentHashMap<String, Class> reflectedClasses = new ConcurrentHashMap();
    public static ConcurrentHashMap<ClassField, Field> reflectedFields = new ConcurrentHashMap();

    public static Class getClass(String className) {
        return reflectedClasses.computeIfAbsent(className, ReflectionUtils::getReflectedClass);
    }

    public static Field getField(Class clss, String fild) {
        return reflectedFields.computeIfAbsent(new ClassField(clss, fild), ReflectionUtils::getReflectedField);
    }

    public static void setFieldToPublic(Field fild) {
        ReflectionUtils.setAccessibleObjectToPublic(fild);
    }

    public static void setMethodToPublic(Method mthod) {
        ReflectionUtils.setAccessibleObjectToPublic(mthod);
    }

    private static void setAccessibleObjectToPublic(AccessibleObject obj) {
        block4: {
            try {
                obj.setAccessible(true);
            }
            catch (SecurityException se) {
                try {
                    Class.forName("java.security.AccessController");
                    AccessControllerUtils.runWithAccessController(() -> {
                        obj.setAccessible(true);
                        return null;
                    });
                }
                catch (ClassNotFoundException | IllegalAccessException e) {
                    if (!UnsafeUtils.canUseUnsafe) break block4;
                    UnsafeUtils.putFieldBoolean(obj, ReflectionUtils.getField(obj.getClass(), "override"), true);
                }
            }
        }
    }

    private static Field getReflectedField(ClassField clssfild) {
        try {
            return clssfild.clss.getField(clssfild.fild());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    private static Class getReflectedClass(String className) {
        try {
            int $loc = className.indexOf("$");
            Class classObj = $loc > -1 ? ReflectionUtils.getNestedClass(Class.forName(className.substring(0, $loc)), className.substring($loc + 1)) : Class.forName(className);
            assert (classObj != null);
            return classObj;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Class getNestedClass(Class upperClass, String nestedClassName) {
        Class<?>[] classObjArr;
        for (Class<?> classArrObj : classObjArr = upperClass.getDeclaredClasses()) {
            if (!classArrObj.getName().equals(upperClass.getName() + "$" + nestedClassName)) continue;
            return classArrObj;
        }
        return null;
    }

    private record ClassField(Class clss, String fild) {
    }
}

