/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.opts.dfc.common.ast.noise;

import com.ishland.c2me.opts.dfc.common.ast.AstNode;
import com.ishland.c2me.opts.dfc.common.ast.AstTransformer;
import com.ishland.c2me.opts.dfc.common.ast.EvalType;
import com.ishland.c2me.opts.dfc.common.gen.BytecodeGen;
import com.ishland.c2me.opts.dfc.common.util.ArrayCache;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_6910;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

public class ShiftedNoiseNode
implements AstNode {
    private final AstNode shiftX;
    private final AstNode shiftY;
    private final AstNode shiftZ;
    private final double xzScale;
    private final double yScale;
    private final class_6910.class_7270 noise;

    public ShiftedNoiseNode(AstNode shiftX, AstNode shiftY, AstNode shiftZ, double xzScale, double yScale, class_6910.class_7270 noise) {
        this.shiftX = Objects.requireNonNull(shiftX);
        this.shiftY = Objects.requireNonNull(shiftY);
        this.shiftZ = Objects.requireNonNull(shiftZ);
        this.xzScale = xzScale;
        this.yScale = yScale;
        this.noise = Objects.requireNonNull(noise);
    }

    @Override
    public double evalSingle(int x, int y, int z, EvalType type) {
        double d = (double)x * this.xzScale + this.shiftX.evalSingle(x, y, z, type);
        double e = (double)y * this.yScale + this.shiftY.evalSingle(x, y, z, type);
        double f = (double)z * this.xzScale + this.shiftZ.evalSingle(x, y, z, type);
        return this.noise.method_42356(d, e, f);
    }

    @Override
    public void evalMulti(double[] res, int[] x, int[] y, int[] z, EvalType type) {
        double[] res1 = new double[res.length];
        double[] res2 = new double[res.length];
        this.shiftX.evalMulti(res, x, y, z, type);
        this.shiftY.evalMulti(res1, x, y, z, type);
        this.shiftZ.evalMulti(res2, x, y, z, type);
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.noise.method_42356((double)x[i] * this.xzScale + res[i], (double)y[i] * this.yScale + res1[i], (double)z[i] * this.xzScale + res2[i]);
        }
    }

    @Override
    public AstNode[] getChildren() {
        return new AstNode[]{this.shiftX, this.shiftY, this.shiftZ};
    }

    @Override
    public AstNode transform(AstTransformer transformer) {
        AstNode shiftX = this.shiftX.transform(transformer);
        AstNode shiftY = this.shiftY.transform(transformer);
        AstNode shiftZ = this.shiftZ.transform(transformer);
        if (shiftX == this.shiftX && shiftY == this.shiftY && shiftZ == this.shiftZ) {
            return transformer.transform(this);
        }
        return transformer.transform(new ShiftedNoiseNode(shiftX, shiftY, shiftZ, this.xzScale, this.yScale, this.noise));
    }

    @Override
    public void doBytecodeGenSingle(BytecodeGen.Context context, InstructionAdapter m, BytecodeGen.Context.LocalVarConsumer localVarConsumer) {
        String noiseField = context.newField(class_6910.class_7270.class, this.noise);
        String shiftXMethod = context.newSingleMethod(this.shiftX);
        String shiftYMethod = context.newSingleMethod(this.shiftY);
        String shiftZMethod = context.newSingleMethod(this.shiftZ);
        m.load(0, InstructionAdapter.OBJECT_TYPE);
        m.getfield(context.className, noiseField, Type.getDescriptor(class_6910.class_7270.class));
        m.load(1, Type.INT_TYPE);
        m.cast(Type.INT_TYPE, Type.DOUBLE_TYPE);
        m.dconst(this.xzScale);
        m.mul(Type.DOUBLE_TYPE);
        context.callDelegateSingle(m, shiftXMethod);
        m.add(Type.DOUBLE_TYPE);
        m.load(2, Type.INT_TYPE);
        m.cast(Type.INT_TYPE, Type.DOUBLE_TYPE);
        m.dconst(this.yScale);
        m.mul(Type.DOUBLE_TYPE);
        context.callDelegateSingle(m, shiftYMethod);
        m.add(Type.DOUBLE_TYPE);
        m.load(3, Type.INT_TYPE);
        m.cast(Type.INT_TYPE, Type.DOUBLE_TYPE);
        m.dconst(this.xzScale);
        m.mul(Type.DOUBLE_TYPE);
        context.callDelegateSingle(m, shiftZMethod);
        m.add(Type.DOUBLE_TYPE);
        m.invokevirtual(Type.getInternalName(class_6910.class_7270.class), FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_6910$class_7270", "method_42356", "(DDD)D"), "(DDD)D", false);
        m.areturn(Type.DOUBLE_TYPE);
    }

    @Override
    public void doBytecodeGenMulti(BytecodeGen.Context context, InstructionAdapter m, BytecodeGen.Context.LocalVarConsumer localVarConsumer) {
        String noiseField = context.newField(class_6910.class_7270.class, this.noise);
        String shiftXMethod = context.newMultiMethod(this.shiftX);
        String shiftYMethod = context.newMultiMethod(this.shiftY);
        String shiftZMethod = context.newMultiMethod(this.shiftZ);
        int res1 = localVarConsumer.createLocalVariable("res1", Type.getDescriptor(double[].class));
        int res2 = localVarConsumer.createLocalVariable("res2", Type.getDescriptor(double[].class));
        m.load(6, InstructionAdapter.OBJECT_TYPE);
        m.load(1, InstructionAdapter.OBJECT_TYPE);
        m.arraylength();
        m.iconst(0);
        m.invokevirtual(Type.getInternalName(ArrayCache.class), "getDoubleArray", Type.getMethodDescriptor((Type)Type.getType(double[].class), (Type[])new Type[]{Type.INT_TYPE, Type.BOOLEAN_TYPE}), false);
        m.store(res1, InstructionAdapter.OBJECT_TYPE);
        m.load(6, InstructionAdapter.OBJECT_TYPE);
        m.load(1, InstructionAdapter.OBJECT_TYPE);
        m.arraylength();
        m.iconst(0);
        m.invokevirtual(Type.getInternalName(ArrayCache.class), "getDoubleArray", Type.getMethodDescriptor((Type)Type.getType(double[].class), (Type[])new Type[]{Type.INT_TYPE, Type.BOOLEAN_TYPE}), false);
        m.store(res2, InstructionAdapter.OBJECT_TYPE);
        context.callDelegateMulti(m, shiftXMethod);
        m.load(0, InstructionAdapter.OBJECT_TYPE);
        m.load(res1, InstructionAdapter.OBJECT_TYPE);
        m.load(2, InstructionAdapter.OBJECT_TYPE);
        m.load(3, InstructionAdapter.OBJECT_TYPE);
        m.load(4, InstructionAdapter.OBJECT_TYPE);
        m.load(5, InstructionAdapter.OBJECT_TYPE);
        m.load(6, InstructionAdapter.OBJECT_TYPE);
        m.invokevirtual(context.className, shiftYMethod, BytecodeGen.Context.MULTI_DESC, false);
        m.load(0, InstructionAdapter.OBJECT_TYPE);
        m.load(res2, InstructionAdapter.OBJECT_TYPE);
        m.load(2, InstructionAdapter.OBJECT_TYPE);
        m.load(3, InstructionAdapter.OBJECT_TYPE);
        m.load(4, InstructionAdapter.OBJECT_TYPE);
        m.load(5, InstructionAdapter.OBJECT_TYPE);
        m.load(6, InstructionAdapter.OBJECT_TYPE);
        m.invokevirtual(context.className, shiftZMethod, BytecodeGen.Context.MULTI_DESC, false);
        context.doCountedLoop(m, localVarConsumer, idx -> {
            m.load(1, InstructionAdapter.OBJECT_TYPE);
            m.load(idx, Type.INT_TYPE);
            m.load(0, InstructionAdapter.OBJECT_TYPE);
            m.getfield(context.className, noiseField, Type.getDescriptor(class_6910.class_7270.class));
            m.load(2, InstructionAdapter.OBJECT_TYPE);
            m.load(idx, Type.INT_TYPE);
            m.aload(Type.INT_TYPE);
            m.cast(Type.INT_TYPE, Type.DOUBLE_TYPE);
            m.dconst(this.xzScale);
            m.mul(Type.DOUBLE_TYPE);
            m.load(1, InstructionAdapter.OBJECT_TYPE);
            m.load(idx, Type.INT_TYPE);
            m.aload(Type.DOUBLE_TYPE);
            m.add(Type.DOUBLE_TYPE);
            m.load(3, InstructionAdapter.OBJECT_TYPE);
            m.load(idx, Type.INT_TYPE);
            m.aload(Type.INT_TYPE);
            m.cast(Type.INT_TYPE, Type.DOUBLE_TYPE);
            m.dconst(this.yScale);
            m.mul(Type.DOUBLE_TYPE);
            m.load(res1, InstructionAdapter.OBJECT_TYPE);
            m.load(idx, Type.INT_TYPE);
            m.aload(Type.DOUBLE_TYPE);
            m.add(Type.DOUBLE_TYPE);
            m.load(4, InstructionAdapter.OBJECT_TYPE);
            m.load(idx, Type.INT_TYPE);
            m.aload(Type.INT_TYPE);
            m.cast(Type.INT_TYPE, Type.DOUBLE_TYPE);
            m.dconst(this.xzScale);
            m.mul(Type.DOUBLE_TYPE);
            m.load(res2, InstructionAdapter.OBJECT_TYPE);
            m.load(idx, Type.INT_TYPE);
            m.aload(Type.DOUBLE_TYPE);
            m.add(Type.DOUBLE_TYPE);
            m.invokevirtual(Type.getInternalName(class_6910.class_7270.class), FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_6910$class_7270", "method_42356", "(DDD)D"), "(DDD)D", false);
            m.astore(Type.DOUBLE_TYPE);
        });
        m.load(6, InstructionAdapter.OBJECT_TYPE);
        m.load(res1, InstructionAdapter.OBJECT_TYPE);
        m.invokevirtual(Type.getInternalName(ArrayCache.class), "recycle", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(double[].class)}), false);
        m.load(6, InstructionAdapter.OBJECT_TYPE);
        m.load(res2, InstructionAdapter.OBJECT_TYPE);
        m.invokevirtual(Type.getInternalName(ArrayCache.class), "recycle", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(double[].class)}), false);
        m.areturn(Type.VOID_TYPE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShiftedNoiseNode that = (ShiftedNoiseNode)o;
        return Double.compare(this.xzScale, that.xzScale) == 0 && Double.compare(this.yScale, that.yScale) == 0 && Objects.equals(this.shiftX, that.shiftX) && Objects.equals(this.shiftY, that.shiftY) && Objects.equals(this.shiftZ, that.shiftZ) && Objects.equals(this.noise, that.noise);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.shiftX.hashCode();
        result = 31 * result + this.shiftY.hashCode();
        result = 31 * result + this.shiftZ.hashCode();
        result = 31 * result + Double.hashCode(this.xzScale);
        result = 31 * result + Double.hashCode(this.yScale);
        result = 31 * result + this.noise.hashCode();
        return result;
    }

    @Override
    public boolean relaxedEquals(AstNode o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShiftedNoiseNode that = (ShiftedNoiseNode)o;
        return Double.compare(this.xzScale, that.xzScale) == 0 && Double.compare(this.yScale, that.yScale) == 0 && this.shiftX.relaxedEquals(that.shiftX) && this.shiftY.relaxedEquals(that.shiftY) && this.shiftZ.relaxedEquals(that.shiftZ);
    }

    @Override
    public int relaxedHashCode() {
        int result = 1;
        result = 31 * result + this.shiftX.relaxedHashCode();
        result = 31 * result + this.shiftY.relaxedHashCode();
        result = 31 * result + this.shiftZ.relaxedHashCode();
        result = 31 * result + Double.hashCode(this.xzScale);
        result = 31 * result + Double.hashCode(this.yScale);
        return result;
    }
}

