/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.server.translations.impl.language;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_3545;
import xyz.nucleoid.server.translations.api.language.ServerLanguageDefinition;
import xyz.nucleoid.server.translations.impl.ServerTranslations;

public class ServerLanguageDefinitionReaders {
    public static class_3545<List<ServerLanguageDefinition>, Map<String, String>> loadLanguageDefinitions() throws IOException {
        ArrayList<ServerLanguageDefinition> languageDefinitions = new ArrayList<ServerLanguageDefinition>();
        HashMap<String, String> aliasList = new HashMap<String, String>();
        try (BufferedReader read = new BufferedReader(new InputStreamReader(ServerTranslations.class.getResourceAsStream("/minecraft_languages.json")));){
            JsonObject root = JsonParser.parseReader((Reader)read).getAsJsonObject();
            JsonObject languageRoot = root.getAsJsonObject("language");
            for (Map.Entry entry : languageRoot.entrySet()) {
                ServerLanguageDefinition definition = ServerLanguageDefinitionReaders.parse((String)entry.getKey(), (JsonObject)entry.getValue());
                languageDefinitions.add(definition);
            }
            JsonObject aliasRoot = root.getAsJsonObject("alias");
            for (Map.Entry entry : aliasRoot.entrySet()) {
                aliasList.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
        return new class_3545(languageDefinitions, aliasList);
    }

    public static ServerLanguageDefinition parse(String code, JsonObject jsonObject) {
        String region = jsonObject.get("region").getAsString();
        String name = jsonObject.get("name").getAsString();
        boolean bidirectional = jsonObject.get("bidirectional").getAsBoolean();
        return new ServerLanguageDefinition(code.toLowerCase(Locale.ROOT), region, name, bidirectional);
    }
}

