/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.lang.management.ManagementFactory;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_155;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.GraphicsCard;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.PhysicalMemory;
import oshi.hardware.VirtualMemory;

public class class_6396 {
    public static final long field_33852 = 0x100000L;
    private static final long field_33853 = 1000000000L;
    private static final Logger field_33854 = LogUtils.getLogger();
    private static final String field_33855 = System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version");
    private static final String field_33856 = System.getProperty("java.version") + ", " + System.getProperty("java.vendor");
    private static final String field_33857 = System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor");
    private final Map<String, String> field_33858 = Maps.newLinkedHashMap();

    public class_6396() {
        this.method_37122("Minecraft Version", class_155.method_16673().comp_4025());
        this.method_37122("Minecraft Version ID", class_155.method_16673().comp_4024());
        this.method_37122("Operating System", field_33855);
        this.method_37122("Java Version", field_33856);
        this.method_37122("Java VM Version", field_33857);
        this.method_37123("Memory", () -> {
            Runtime $$0 = Runtime.getRuntime();
            long $$1 = $$0.maxMemory();
            long $$2 = $$0.totalMemory();
            long $$3 = $$0.freeMemory();
            long $$4 = $$1 / 0x100000L;
            long $$5 = $$2 / 0x100000L;
            long $$6 = $$3 / 0x100000L;
            return $$3 + " bytes (" + $$6 + " MiB) / " + $$2 + " bytes (" + $$5 + " MiB) up to " + $$1 + " bytes (" + $$4 + " MiB)";
        });
        this.method_37123("CPUs", () -> String.valueOf(Runtime.getRuntime().availableProcessors()));
        this.method_37121("hardware", () -> this.method_37128(new SystemInfo()));
        this.method_37123("JVM Flags", () -> class_6396.method_74464($$0 -> $$0.startsWith("-X")));
        this.method_37123("Debug Flags", () -> class_6396.method_74464($$0 -> $$0.startsWith("-DMC_DEBUG_")));
    }

    private static String method_74464(Predicate<String> $$0) {
        List<String> $$1 = ManagementFactory.getRuntimeMXBean().getInputArguments();
        List<String> $$2 = $$1.stream().filter($$0).toList();
        return String.format(Locale.ROOT, "%d total; %s", $$2.size(), String.join((CharSequence)" ", $$2));
    }

    public void method_37122(String $$0, String $$1) {
        this.field_33858.put($$0, $$1);
    }

    public void method_37123(String $$0, Supplier<String> $$1) {
        try {
            this.method_37122($$0, $$1.get());
        }
        catch (Exception $$2) {
            field_33854.warn("Failed to get system info for {}", (Object)$$0, (Object)$$2);
            this.method_37122($$0, "ERR");
        }
    }

    private void method_37128(SystemInfo $$0) {
        HardwareAbstractionLayer $$1 = $$0.getHardware();
        this.method_37121("processor", () -> this.method_37130($$1.getProcessor()));
        this.method_37121("graphics", () -> this.method_37137($$1.getGraphicsCards()));
        this.method_37121("memory", () -> this.method_37131($$1.getMemory()));
        this.method_37121("storage", this::method_59897);
    }

    private void method_37121(String $$0, Runnable $$1) {
        try {
            $$1.run();
        }
        catch (Throwable $$2) {
            field_33854.warn("Failed retrieving info for group {}", (Object)$$0, (Object)$$2);
        }
    }

    public static float method_59895(long $$0) {
        return (float)$$0 / 1048576.0f;
    }

    private void method_37126(List<PhysicalMemory> $$0) {
        int $$1 = 0;
        for (PhysicalMemory $$2 : $$0) {
            String $$3 = String.format(Locale.ROOT, "Memory slot #%d ", $$1++);
            this.method_37123($$3 + "capacity (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(class_6396.method_59895($$2.getCapacity()))));
            this.method_37123($$3 + "clockSpeed (GHz)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf((float)$$2.getClockSpeed() / 1.0E9f)));
            this.method_37123($$3 + "type", () -> ((PhysicalMemory)$$2).getMemoryType());
        }
    }

    private void method_37135(VirtualMemory $$0) {
        this.method_37123("Virtual memory max (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(class_6396.method_59895($$0.getVirtualMax()))));
        this.method_37123("Virtual memory used (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(class_6396.method_59895($$0.getVirtualInUse()))));
        this.method_37123("Swap memory total (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(class_6396.method_59895($$0.getSwapTotal()))));
        this.method_37123("Swap memory used (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(class_6396.method_59895($$0.getSwapUsed()))));
    }

    private void method_37131(GlobalMemory $$0) {
        this.method_37121("physical memory", () -> this.method_37126($$0.getPhysicalMemory()));
        this.method_37121("virtual memory", () -> this.method_37135($$0.getVirtualMemory()));
    }

    private void method_37137(List<GraphicsCard> $$0) {
        int $$1 = 0;
        for (GraphicsCard $$2 : $$0) {
            String $$3 = String.format(Locale.ROOT, "Graphics card #%d ", $$1++);
            this.method_37123($$3 + "name", () -> ((GraphicsCard)$$2).getName());
            this.method_37123($$3 + "vendor", () -> ((GraphicsCard)$$2).getVendor());
            this.method_37123($$3 + "VRAM (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(class_6396.method_59895($$2.getVRam()))));
            this.method_37123($$3 + "deviceId", () -> ((GraphicsCard)$$2).getDeviceId());
            this.method_37123($$3 + "versionInfo", () -> ((GraphicsCard)$$2).getVersionInfo());
        }
    }

    private void method_37130(CentralProcessor $$0) {
        CentralProcessor.ProcessorIdentifier $$1 = $$0.getProcessorIdentifier();
        this.method_37123("Processor Vendor", () -> ((CentralProcessor.ProcessorIdentifier)$$1).getVendor());
        this.method_37123("Processor Name", () -> ((CentralProcessor.ProcessorIdentifier)$$1).getName());
        this.method_37123("Identifier", () -> ((CentralProcessor.ProcessorIdentifier)$$1).getIdentifier());
        this.method_37123("Microarchitecture", () -> ((CentralProcessor.ProcessorIdentifier)$$1).getMicroarchitecture());
        this.method_37123("Frequency (GHz)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf((float)$$1.getVendorFreq() / 1.0E9f)));
        this.method_37123("Number of physical packages", () -> String.valueOf($$0.getPhysicalPackageCount()));
        this.method_37123("Number of physical CPUs", () -> String.valueOf($$0.getPhysicalProcessorCount()));
        this.method_37123("Number of logical CPUs", () -> String.valueOf($$0.getLogicalProcessorCount()));
    }

    private void method_59897() {
        this.method_59896("jna.tmpdir");
        this.method_59896("org.lwjgl.system.SharedLibraryExtractPath");
        this.method_59896("io.netty.native.workdir");
        this.method_59896("java.io.tmpdir");
        this.method_59899("workdir", () -> "");
    }

    private void method_59896(String $$0) {
        this.method_59899($$0, () -> System.getProperty($$0));
    }

    private void method_59899(String $$0, Supplier<@Nullable String> $$1) {
        String $$2 = "Space in storage for " + $$0 + " (MiB)";
        try {
            String $$3 = $$1.get();
            if ($$3 == null) {
                this.method_37122($$2, "<path not set>");
                return;
            }
            FileStore $$4 = Files.getFileStore(Path.of($$3, new String[0]));
            this.method_37122($$2, String.format(Locale.ROOT, "available: %.2f, total: %.2f", Float.valueOf(class_6396.method_59895($$4.getUsableSpace())), Float.valueOf(class_6396.method_59895($$4.getTotalSpace()))));
        }
        catch (InvalidPathException $$5) {
            field_33854.warn("{} is not a path", (Object)$$0, (Object)$$5);
            this.method_37122($$2, "<invalid path>");
        }
        catch (Exception $$6) {
            field_33854.warn("Failed retrieving storage space for {}", (Object)$$0, (Object)$$6);
            this.method_37122($$2, "ERR");
        }
    }

    public void method_37124(StringBuilder $$0) {
        $$0.append("-- ").append("System Details").append(" --\n");
        $$0.append("Details:");
        this.field_33858.forEach(($$1, $$2) -> {
            $$0.append("\n\t");
            $$0.append((String)$$1);
            $$0.append(": ");
            $$0.append((String)$$2);
        });
    }

    public String method_37120() {
        return this.field_33858.entrySet().stream().map($$0 -> (String)$$0.getKey() + ": " + (String)$$0.getValue()).collect(Collectors.joining(System.lineSeparator()));
    }
}

