/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.LinkedList;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Updaters {
    static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME Config Updater");
    private static final Long2ObjectOpenHashMap<Consumer<Config>> updaters = new Long2ObjectOpenHashMap();

    public static void update(Config config) {
        long version;
        Consumer updater;
        while ((updater = (Consumer)updaters.get(version = config.getLongOrElse("version", 0L))) != null) {
            LOGGER.info("Updating config from {} to {}", (Object)version, (Object)(version + 1L));
            updater.accept(config);
            config.set("version", (Object)(version + 1L));
        }
    }

    static {
        updaters.put(0L, source -> {
            LinkedList<Runnable> pendingActions = new LinkedList<Runnable>();
            LinkedList<Config> pendingConfigs = new LinkedList<Config>();
            pendingConfigs.add((Config)source);
            while (!pendingConfigs.isEmpty()) {
                Config config = (Config)pendingConfigs.poll();
                for (Config.Entry entry : config.entrySet()) {
                    if (entry.getValue() instanceof Config) {
                        pendingConfigs.add((Config)entry.getValue());
                        continue;
                    }
                    pendingActions.add(() -> entry.setValue((Object)"default"));
                }
            }
            pendingActions.forEach(Runnable::run);
        });
        updaters.put(1L, source -> {
            Object _ioSystem = source.get("asyncIO");
            if (_ioSystem instanceof CommentedConfig) {
                CommentedConfig ioSystem = (CommentedConfig)_ioSystem;
                source.remove("asyncIO");
                source.add("ioSystem", (Object)ioSystem);
                Object _async = ioSystem.get("enabled");
                if (_async instanceof Boolean) {
                    Boolean async = (Boolean)_async;
                    ioSystem.remove("enabled");
                    ioSystem.add("async", (Object)async);
                }
            }
        });
        updaters.put(2L, source -> {
            Object _generalOptimizations = source.get("generalOptimizations");
            Object _ioSystem = source.get("ioSystem");
            if (_generalOptimizations instanceof CommentedConfig) {
                CommentedConfig generalOptimizations = (CommentedConfig)_generalOptimizations;
                if (_ioSystem instanceof CommentedConfig) {
                    CommentedConfig ioSystem = (CommentedConfig)_ioSystem;
                    Object _chunkStreamVersion = generalOptimizations.get("chunkStreamVersion");
                    if (_chunkStreamVersion instanceof Number) {
                        Number chunkStreamVersion = (Number)_chunkStreamVersion;
                        generalOptimizations.remove("chunkStreamVersion");
                        ioSystem.add("chunkStreamVersion", (Object)chunkStreamVersion);
                    }
                }
            }
        });
    }
}

