/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.flowsched.scheduler;

import com.ishland.flowsched.scheduler.ItemStatus;
import com.ishland.flowsched.scheduler.ItemTicket;
import com.ishland.flowsched.scheduler.ObjectFactory;
import com.ishland.flowsched.util.Assertions;
import java.lang.invoke.VarHandle;
import java.util.Set;

public class TicketSet<K, V, Ctx> {
    private final ItemStatus<K, V, Ctx> initialStatus;
    private final Set<ItemTicket<K, V, Ctx>>[] status2Tickets;
    private final int[] status2TicketsSize;
    private volatile int targetStatus = 0;

    public TicketSet(ItemStatus<K, V, Ctx> initialStatus, ObjectFactory objectFactory) {
        this.initialStatus = initialStatus;
        this.targetStatus = initialStatus.ordinal();
        ItemStatus<K, V, Ctx>[] allStatuses = initialStatus.getAllStatuses();
        this.status2Tickets = new Set[allStatuses.length];
        for (int i = 0; i < allStatuses.length; ++i) {
            this.status2Tickets[i] = objectFactory.createConcurrentSet();
        }
        this.status2TicketsSize = new int[allStatuses.length];
        VarHandle.fullFence();
    }

    public boolean checkAdd(ItemTicket<K, V, Ctx> ticket) {
        ItemStatus<K, V, Ctx> targetStatus = ticket.getTargetStatus();
        boolean added = this.status2Tickets[targetStatus.ordinal()].add(ticket);
        return added;
    }

    public void addUnchecked(ItemTicket<K, V, Ctx> ticket) {
        ItemStatus<K, V, Ctx> targetStatus = ticket.getTargetStatus();
        int n = targetStatus.ordinal();
        this.status2TicketsSize[n] = this.status2TicketsSize[n] + 1;
        this.updateTargetStatus();
    }

    public boolean checkRemove(ItemTicket<K, V, Ctx> ticket) {
        ItemStatus<K, V, Ctx> targetStatus = ticket.getTargetStatus();
        boolean removed = this.status2Tickets[targetStatus.ordinal()].remove(ticket);
        return removed;
    }

    public void removeUnchecked(ItemTicket<K, V, Ctx> ticket) {
        ItemStatus<K, V, Ctx> targetStatus = ticket.getTargetStatus();
        int n = targetStatus.ordinal();
        this.status2TicketsSize[n] = this.status2TicketsSize[n] - 1;
        this.updateTargetStatus();
    }

    private void updateTargetStatus() {
        this.targetStatus = this.computeTargetStatusSlow();
    }

    public ItemStatus<K, V, Ctx> getTargetStatus() {
        return this.initialStatus.getAllStatuses()[this.targetStatus];
    }

    public Set<ItemTicket<K, V, Ctx>> getTicketsForStatus(ItemStatus<K, V, Ctx> status) {
        return this.status2Tickets[status.ordinal()];
    }

    void clear() {
        for (Set<ItemTicket<K, V, Ctx>> tickets : this.status2Tickets) {
            tickets.clear();
        }
        VarHandle.fullFence();
    }

    void assertEmpty() {
        for (Set<ItemTicket<K, V, Ctx>> tickets : this.status2Tickets) {
            Assertions.assertTrue(tickets.isEmpty());
        }
    }

    private int computeTargetStatusSlow() {
        for (int i = this.status2Tickets.length - 1; i > 0; --i) {
            if (this.status2TicketsSize[i] <= 0) continue;
            return i;
        }
        return 0;
    }
}

