/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.packettweaker.impl;

import com.mojang.authlib.GameProfile;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_8791;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.ContextProvidingPacketListener;
import xyz.nucleoid.packettweaker.PacketContext;
import xyz.nucleoid.packettweaker.impl.EmptyContext;
import xyz.nucleoid.packettweaker.impl.StaticPacketContext;

public final class MutableContext
implements PacketContext.NotNullWithPlayer {
    private static final ThreadLocal<MutableContext> INSTANCE = ThreadLocal.withInitial(MutableContext::new);
    private ContextProvidingPacketListener target = ContextProvidingPacketListener.EMPTY;
    @Nullable
    private class_2596<?> encodedPacket = null;
    @Nullable
    private class_2535 connection = null;

    public static MutableContext get() {
        return INSTANCE.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithContext(@Nullable class_2535 connection, @Nullable class_2547 networkHandler, @Nullable class_2596<?> packet, Runnable runnable) {
        MutableContext context = MutableContext.get();
        ContextProvidingPacketListener oldTarget = context.target;
        class_2596<?> oldPacket = context.encodedPacket;
        class_2535 oldConnection = context.connection;
        context.target = ContextProvidingPacketListener.of(networkHandler);
        context.encodedPacket = packet;
        context.connection = connection;
        try {
            runnable.run();
        }
        finally {
            context.target = oldTarget;
            context.encodedPacket = oldPacket;
            context.connection = oldConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T supplyWithContext(@Nullable class_2535 connection, @Nullable class_2547 networkHandler, @Nullable class_2596<?> packet, Supplier<T> supplier) {
        MutableContext context = MutableContext.get();
        ContextProvidingPacketListener oldTarget = context.target;
        class_2596<?> oldPacket = context.encodedPacket;
        class_2535 oldConnection = context.connection;
        context.target = ContextProvidingPacketListener.of(networkHandler);
        context.encodedPacket = packet;
        context.connection = connection;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            context.target = oldTarget;
            context.encodedPacket = oldPacket;
            context.connection = oldConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T supplyWithContext(@Nullable class_2535 connection, @Nullable class_2547 networkHandler, @Nullable class_2596<?> packet, Function<PacketContext, T> supplier) {
        MutableContext context = MutableContext.get();
        ContextProvidingPacketListener oldTarget = context.target;
        class_2596<?> oldPacket = context.encodedPacket;
        class_2535 oldConnection = context.connection;
        context.target = ContextProvidingPacketListener.of(networkHandler);
        context.encodedPacket = packet;
        context.connection = connection;
        try {
            T t = supplier.apply(context);
            return t;
        }
        finally {
            context.target = oldTarget;
            context.encodedPacket = oldPacket;
            context.connection = oldConnection;
        }
    }

    @Override
    @Nullable
    public class_3222 getPlayer() {
        return this.target.getPlayerForPacketTweaker();
    }

    @Override
    @Nullable
    public class_8791 getClientOptions() {
        return this.target.getClientOptionsForPacketTweaker();
    }

    @Override
    @Nullable
    public GameProfile getGameProfile() {
        return this.target.getGameProfileForPacketTweaker();
    }

    @Override
    public PacketContext.NotNullWithPlayer copy() {
        return this.connection != null ? new StaticPacketContext(this.connection) : EmptyContext.INSTANCE;
    }

    @Override
    @Nullable
    public class_7225.class_7874 getRegistryWrapperLookup() {
        return this.target.getWrapperLookupForPacketTweaker();
    }

    @Override
    public ContextProvidingPacketListener getPacketListener() {
        return this.target;
    }

    @Override
    @Nullable
    public class_2547 getBackingPacketListener() {
        return this.target != ContextProvidingPacketListener.EMPTY ? (class_2547)this.target : null;
    }

    @Override
    @Nullable
    public class_2535 getClientConnection() {
        return this.connection;
    }

    @Override
    @Nullable
    public class_2596<?> getEncodedPacket() {
        return this.encodedPacket;
    }

    @Override
    @Nullable
    public PacketContext.NotNull asNotNull() {
        return this.getClientConnection() != null && this.getRegistryWrapperLookup() != null ? this : null;
    }

    @Override
    @Nullable
    public PacketContext.NotNullWithPlayer asNotNullWithPlayer() {
        return this.getPlayer() != null ? this : null;
    }

    public void clear() {
        this.target = ContextProvidingPacketListener.EMPTY;
        this.connection = null;
        this.encodedPacket = null;
    }

    public void set(class_2535 connection, class_2596<?> packet) {
        if (connection == null) {
            this.clear();
            return;
        }
        this.target = (ContextProvidingPacketListener)connection.method_10744();
        this.connection = connection;
        this.encodedPacket = packet;
    }

    public void set(class_2547 listener, class_2596<?> packet) {
        if (listener == null) {
            this.clear();
            return;
        }
        this.target = (ContextProvidingPacketListener)listener;
        this.connection = this.target.getClientConnectionForPacketTweaker();
        this.encodedPacket = packet;
    }
}

