/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.registry;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_7;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LandPathNodeTypesRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(LandPathNodeTypesRegistry.class);
    private static final Map<class_2248, PathNodeTypeProvider> NODE_TYPES = new IdentityHashMap<class_2248, PathNodeTypeProvider>();

    private LandPathNodeTypesRegistry() {
    }

    public static void register(class_2248 block, @Nullable class_7 nodeType, @Nullable class_7 nodeTypeIfNeighbor) {
        Objects.requireNonNull(block, "Block cannot be null!");
        LandPathNodeTypesRegistry.register(block, (state, neighbor) -> neighbor ? nodeTypeIfNeighbor : nodeType);
    }

    public static void register(class_2248 block, StaticPathNodeTypeProvider provider) {
        Objects.requireNonNull(block, "Block cannot be null!");
        Objects.requireNonNull(provider, "StaticPathNodeTypeProvider cannot be null!");
        PathNodeTypeProvider old = NODE_TYPES.put(block, provider);
        if (old != null) {
            LOGGER.debug("Replaced PathNodeType provider for the block {}", (Object)block);
        }
    }

    public static void registerDynamic(class_2248 block, DynamicPathNodeTypeProvider provider) {
        Objects.requireNonNull(block, "Block cannot be null!");
        Objects.requireNonNull(provider, "DynamicPathNodeTypeProvider cannot be null!");
        PathNodeTypeProvider old = NODE_TYPES.put(block, provider);
        if (old != null) {
            LOGGER.debug("Replaced PathNodeType provider for the block {}", (Object)block);
        }
    }

    public static @Nullable class_7 getPathNodeType(class_2680 state, class_1922 world, class_2338 pos, boolean neighbor) {
        Objects.requireNonNull(state, "BlockState cannot be null!");
        Objects.requireNonNull(world, "BlockView cannot be null!");
        Objects.requireNonNull(pos, "BlockPos cannot be null!");
        PathNodeTypeProvider provider = LandPathNodeTypesRegistry.getPathNodeTypeProvider(state.method_26204());
        if (provider == null) {
            return null;
        }
        if (provider instanceof DynamicPathNodeTypeProvider) {
            return ((DynamicPathNodeTypeProvider)provider).getPathNodeType(state, world, pos, neighbor);
        }
        return ((StaticPathNodeTypeProvider)provider).getPathNodeType(state, neighbor);
    }

    public static @Nullable PathNodeTypeProvider getPathNodeTypeProvider(class_2248 block) {
        Objects.requireNonNull(block, "Block cannot be null!");
        return NODE_TYPES.get(block);
    }

    @FunctionalInterface
    public static non-sealed interface StaticPathNodeTypeProvider
    extends PathNodeTypeProvider {
        public @Nullable class_7 getPathNodeType(class_2680 var1, boolean var2);
    }

    public static sealed interface PathNodeTypeProvider
    permits StaticPathNodeTypeProvider, DynamicPathNodeTypeProvider {
    }

    @FunctionalInterface
    public static non-sealed interface DynamicPathNodeTypeProvider
    extends PathNodeTypeProvider {
        public @Nullable class_7 getPathNodeType(class_2680 var1, class_1922 var2, class_2338 var3, boolean var4);
    }
}

