/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunksystem.common;

import com.ishland.c2me.base.common.scheduler.IVanillaChunkManager;
import com.ishland.c2me.base.common.scheduler.SchedulingManager;
import com.ishland.c2me.base.mixin.access.IThreadedAnvilChunkStorage;
import com.ishland.c2me.base.mixin.access.IVersionedChunkStorage;
import com.ishland.c2me.rewrites.chunksystem.common.ChunkLoadingContext;
import com.ishland.c2me.rewrites.chunksystem.common.ChunkState;
import com.ishland.c2me.rewrites.chunksystem.common.Config;
import com.ishland.c2me.rewrites.chunksystem.common.NewChunkHolderVanillaInterface;
import com.ishland.c2me.rewrites.chunksystem.common.NewChunkStatus;
import com.ishland.c2me.rewrites.chunksystem.common.TheSpeedyObjectFactory;
import com.ishland.c2me.rewrites.chunksystem.common.TicketTypeExtension;
import com.ishland.c2me.rewrites.chunksystem.common.structs.ChunkSystemExecutors;
import com.ishland.flowsched.scheduler.ExceptionHandlingAction;
import com.ishland.flowsched.scheduler.ItemHolder;
import com.ishland.flowsched.scheduler.ItemStatus;
import com.ishland.flowsched.scheduler.KeyStatusPair;
import com.ishland.flowsched.scheduler.StatusAdvancingScheduler;
import com.ishland.flowsched.util.Assertions;
import io.reactivex.rxjava3.core.Scheduler;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.concurrent.Executor;
import net.minecraft.class_1923;
import net.minecraft.class_3193;
import net.minecraft.class_3568;
import net.minecraft.class_3898;
import net.minecraft.class_5539;
import net.minecraft.class_9761;
import net.minecraft.class_9762;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TheChunkSystem
extends StatusAdvancingScheduler<class_1923, ChunkState, ChunkLoadingContext, NewChunkHolderVanillaInterface> {
    private final Logger LOGGER;
    private final Long2IntMap managedTickets = Long2IntMaps.synchronize((Long2IntMap)new Long2IntOpenHashMap());
    private final SchedulingManager schedulingManager;
    private final class_3898 tacs;

    public TheChunkSystem(class_3898 tacs) {
        super(TheSpeedyObjectFactory.INSTANCE);
        this.tacs = tacs;
        this.schedulingManager = ((IVanillaChunkManager)tacs).c2me$getSchedulingManager();
        this.LOGGER = LoggerFactory.getLogger((String)"Chunk System of %s".formatted(((IThreadedAnvilChunkStorage)tacs).getWorld().method_27983().method_29177()));
        this.managedTickets.defaultReturnValue(NewChunkStatus.vanillaLevelToStatus.length - 1);
    }

    protected Executor getBackgroundExecutor() {
        return ChunkSystemExecutors.consolidatingBackgroundExecutor;
    }

    protected Scheduler getSchedulerBackedByBackgroundExecutor() {
        return ChunkSystemExecutors.consolidatingBackgroundScheduler;
    }

    protected ItemStatus<class_1923, ChunkState, ChunkLoadingContext> getUnloadedStatus() {
        return NewChunkStatus.NEW;
    }

    protected ChunkLoadingContext makeContext(ItemHolder<class_1923, ChunkState, ChunkLoadingContext, NewChunkHolderVanillaInterface> holder, ItemStatus<class_1923, ChunkState, ChunkLoadingContext> nextStatus, KeyStatusPair<class_1923, ChunkState, ChunkLoadingContext>[] dependencies, boolean isUpgrade) {
        int radius;
        Assertions.assertTrue((boolean)(nextStatus instanceof NewChunkStatus));
        NewChunkStatus nextStatus1 = (NewChunkStatus)nextStatus;
        if (dependencies.length == 0) {
            radius = 0;
        } else {
            int actualDependencies = dependencies.length + 1;
            radius = (int)((Math.sqrt(actualDependencies) - 1.0) / 2.0);
            Assertions.assertTrue(((radius * 2 + 1) * (radius * 2 + 1) == actualDependencies ? 1 : 0) != 0);
        }
        return new ChunkLoadingContext(holder, this.tacs, this.schedulingManager, (class_9762<class_9761>)class_9762.method_60483((int)((class_1923)holder.getKey()).field_9181, (int)((class_1923)holder.getKey()).field_9180, (int)radius, (x, z) -> (class_9761)this.getHolder(new class_1923(x, z)).getUserData().get()), dependencies);
    }

    protected ExceptionHandlingAction handleTransactionException(ItemHolder<class_1923, ChunkState, ChunkLoadingContext, NewChunkHolderVanillaInterface> holder, ItemStatus<class_1923, ChunkState, ChunkLoadingContext> nextStatus, boolean isUpgrade, Throwable throwable) {
        if (isUpgrade) {
            this.LOGGER.error("Error upgrading chunk {} to \"{}\"", new Object[]{holder.getKey(), nextStatus, throwable});
        } else {
            this.LOGGER.error("Error downgrading chunk {} to \"{}\"", new Object[]{holder.getKey(), nextStatus, throwable});
        }
        MinecraftServer server = ((IThreadedAnvilChunkStorage)this.tacs).getWorld().method_8503();
        server.execute(() -> server.method_57821(throwable, ((IVersionedChunkStorage)this.tacs).invokeGetStorageKey(), (class_1923)holder.getKey()));
        return ExceptionHandlingAction.MARK_BROKEN;
    }

    protected void onItemCreation(ItemHolder<class_1923, ChunkState, ChunkLoadingContext, NewChunkHolderVanillaInterface> holder) {
        super.onItemCreation(holder);
        holder.getUserData().set(new NewChunkHolderVanillaInterface(this, holder, (class_5539)((IThreadedAnvilChunkStorage)this.tacs).getWorld(), (class_3568)((IThreadedAnvilChunkStorage)this.tacs).getLightingProvider(), (class_3193.class_3897)this.tacs));
        holder.getItem().set(new ChunkState(null, null, null));
    }

    protected void onItemRemoval(ItemHolder<class_1923, ChunkState, ChunkLoadingContext, NewChunkHolderVanillaInterface> holder) {
        super.onItemRemoval(holder);
    }

    protected void onItemUpgrade(ItemHolder<class_1923, ChunkState, ChunkLoadingContext, NewChunkHolderVanillaInterface> holder, ItemStatus<class_1923, ChunkState, ChunkLoadingContext> statusReached) {
        super.onItemUpgrade(holder, statusReached);
        NewChunkStatus statusReached1 = (NewChunkStatus)statusReached;
        NewChunkStatus prevStatus = (NewChunkStatus)statusReached.getPrev();
        if (prevStatus.toChunkLevelType() != statusReached1.toChunkLevelType()) {
            ((IThreadedAnvilChunkStorage)this.tacs).getMainThreadExecutor().execute(() -> ((IThreadedAnvilChunkStorage)this.tacs).invokeOnChunkStatusChange((class_1923)holder.getKey(), statusReached1.toChunkLevelType()));
        }
    }

    protected void onItemDowngrade(ItemHolder<class_1923, ChunkState, ChunkLoadingContext, NewChunkHolderVanillaInterface> holder, ItemStatus<class_1923, ChunkState, ChunkLoadingContext> statusReached) {
        super.onItemDowngrade(holder, statusReached);
        NewChunkStatus statusReached1 = (NewChunkStatus)statusReached;
        NewChunkStatus prevStatus = (NewChunkStatus)statusReached.getNext();
        if (prevStatus.toChunkLevelType() != statusReached1.toChunkLevelType()) {
            ((IThreadedAnvilChunkStorage)this.tacs).getMainThreadExecutor().execute(() -> ((IThreadedAnvilChunkStorage)this.tacs).invokeOnChunkStatusChange((class_1923)holder.getKey(), statusReached1.toChunkLevelType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public class_3193 vanillaIf$setLevel(long pos, int level) {
        assert (!Thread.holdsLock(this.managedTickets));
        Long2IntMap long2IntMap = this.managedTickets;
        synchronized (long2IntMap) {
            int oldLevel = this.managedTickets.put(pos, level);
            NewChunkStatus oldStatus = TheChunkSystem.c2me$getDeferredStatusFromVanillaLevel(oldLevel);
            NewChunkStatus newStatus = TheChunkSystem.c2me$getDeferredStatusFromVanillaLevel(level);
            class_1923 key = new class_1923(pos);
            if (oldStatus != newStatus) {
                boolean shouldReturnVanillaHolder;
                ItemHolder holder;
                if (newStatus != this.getUnloadedStatus()) {
                    holder = this.addTicket(key, TicketTypeExtension.VANILLA_LEVEL, key, newStatus, NO_OP);
                    shouldReturnVanillaHolder = true;
                } else {
                    this.managedTickets.remove(pos);
                    holder = this.getHolder(key);
                    shouldReturnVanillaHolder = false;
                }
                Assertions.assertTrue((holder != null ? 1 : 0) != 0, (String)"Holder should be managed by the vanilla interface");
                assert (holder != null);
                NewChunkHolderVanillaInterface vanillaHolder = (NewChunkHolderVanillaInterface)((Object)holder.getUserData().get());
                if (!Config.useLegacyScheduling) {
                    vanillaHolder.updateDeferredStatus(NewChunkStatus.fromVanillaLevel(level));
                }
                if (oldStatus != this.getUnloadedStatus()) {
                    this.removeTicket(key, TicketTypeExtension.VANILLA_LEVEL, key, oldStatus);
                }
                return shouldReturnVanillaHolder ? vanillaHolder : null;
            }
            ItemHolder holder = this.getHolder(key);
            NewChunkHolderVanillaInterface vanillaHolder = holder != null ? (NewChunkHolderVanillaInterface)((Object)holder.getUserData().get()) : null;
            if (!Config.useLegacyScheduling && vanillaHolder != null) {
                vanillaHolder.updateDeferredStatus(NewChunkStatus.fromVanillaLevel(level));
            }
            if (newStatus != this.getUnloadedStatus() && vanillaHolder != null) {
                return vanillaHolder;
            }
            return null;
        }
    }

    private static NewChunkStatus c2me$getDeferredStatusFromVanillaLevel(int level) {
        NewChunkStatus status = NewChunkStatus.fromVanillaLevel(level);
        if (!Config.useLegacyScheduling) {
            if (status == NewChunkStatus.NEW) {
                return status;
            }
            if (status.ordinal() < NewChunkStatus.SERVER_ACCESSIBLE.ordinal()) {
                return NewChunkStatus.DEFERRED;
            }
            return status;
        }
        return status;
    }

    public int vanillaIf$getManagedLevel(long pos) {
        return this.managedTickets.get(pos);
    }
}

