/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunksystem.common;

import com.ishland.flowsched.scheduler.ObjectFactory;
import io.netty.util.internal.PlatformDependent;
import java.security.AccessController;
import java.util.Collections;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.jctools.queues.MpscUnboundedArrayQueue;
import org.jctools.queues.atomic.MpscAtomicArrayQueue;
import org.jctools.util.UnsafeAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TheSpeedyObjectFactory
implements ObjectFactory {
    private static final Logger LOGGER;
    public static final ObjectFactory INSTANCE;
    private final boolean hasUnsafe;

    private TheSpeedyObjectFactory(boolean hasUnsafe) {
        this.hasUnsafe = hasUnsafe;
    }

    public <K, V> ConcurrentMap<K, V> createConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public <E> Set<E> createConcurrentSet() {
        return Collections.newSetFromMap(this.createConcurrentHashMap());
    }

    public <E> Queue<E> newMPMCQueue() {
        return new ConcurrentLinkedQueue();
    }

    public <E> Queue<E> newMPSCQueue() {
        return this.hasUnsafe ? new MpscUnboundedArrayQueue(1024) : new MpscAtomicArrayQueue(1024);
    }

    static {
        boolean hasUnsafe;
        LOGGER = LoggerFactory.getLogger((String)"TheSpeedyObjectFactory");
        Object unsafe = null;
        if (PlatformDependent.hasUnsafe()) {
            try {
                unsafe = AccessController.doPrivileged(() -> UnsafeAccess.UNSAFE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        boolean bl = hasUnsafe = unsafe != null;
        if (hasUnsafe) {
            LOGGER.info("Using TheSpeedyObjectFactory with Unsafe");
        } else {
            LOGGER.info("Using TheSpeedyObjectFactory without Unsafe");
        }
        INSTANCE = new TheSpeedyObjectFactory(hasUnsafe);
    }
}

