/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.client.common.hud.card;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import me.jfenn.bingo.client.common.hud.card.ClientCardBufferRenderer;
import me.jfenn.bingo.client.common.state.BingoHudState;
import me.jfenn.bingo.client.common.state.ClientCard;
import me.jfenn.bingo.client.common.state.ClientCardBase;
import me.jfenn.bingo.client.platform.renderer.IDrawService;
import me.jfenn.bingo.client.platform.renderer.IDrawServiceFactory;
import me.jfenn.bingo.client.platform.renderer.IFramebuffer;
import me.jfenn.bingo.client.platform.renderer.IMatrixStack;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.map.CardView;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.utils.DurationKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ#\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u0016\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010#\u001a\u00020\u001c2\b\u0010 \u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b$\u0010%J\r\u0010&\u001a\u00020\u001c\u00a2\u0006\u0004\b&\u0010'R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010(R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010)R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010*R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010+R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010,\u00a8\u0006-"}, d2={"Lme/jfenn/bingo/client/common/hud/card/ClientCardManager;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/client/platform/renderer/IDrawServiceFactory;", "drawServiceFactory", "Lme/jfenn/bingo/client/common/hud/card/ClientCardBufferRenderer;", "clientCardBufferRenderer", "Lme/jfenn/bingo/client/common/state/BingoHudState;", "state", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/client/platform/renderer/IDrawServiceFactory;Lme/jfenn/bingo/client/common/hud/card/ClientCardBufferRenderer;Lme/jfenn/bingo/client/common/state/BingoHudState;Lme/jfenn/bingo/common/config/BingoConfig;)V", "", "cardScale", "Lkotlin/Pair;", "", "getCardSize", "(F)Lkotlin/Pair;", "Lme/jfenn/bingo/common/map/CardView;", "view", "scale", "Lme/jfenn/bingo/client/common/state/ClientCardBase;", "newCard", "(Lme/jfenn/bingo/common/map/CardView;F)Lme/jfenn/bingo/client/common/state/ClientCardBase;", "Lme/jfenn/bingo/client/common/state/ClientCard;", "card", "", "resizeCard", "(Lme/jfenn/bingo/client/common/state/ClientCard;F)V", "Lme/jfenn/bingo/common/team/BingoTeamKey;", "key", "markDirty-2vhwn7g", "(Ljava/lang/String;)V", "markDirty", "updateCard", "(Lme/jfenn/bingo/client/common/state/ClientCard;)V", "updateCards", "()V", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/client/platform/renderer/IDrawServiceFactory;", "Lme/jfenn/bingo/client/common/hud/card/ClientCardBufferRenderer;", "Lme/jfenn/bingo/client/common/state/BingoHudState;", "Lme/jfenn/bingo/common/config/BingoConfig;", "bingo-common_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nClientCardManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientCardManager.kt\nme/jfenn/bingo/client/common/hud/card/ClientCardManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 IMatrixStack.kt\nme/jfenn/bingo/client/platform/renderer/IMatrixStackKt\n*L\n1#1,91:1\n1#2:92\n17#3,7:93\n*S KotlinDebug\n*F\n+ 1 ClientCardManager.kt\nme/jfenn/bingo/client/common/hud/card/ClientCardManager\n*L\n65#1:93,7\n*E\n"})
public final class ClientCardManager {
    @NotNull
    private final Logger log;
    @NotNull
    private final IDrawServiceFactory drawServiceFactory;
    @NotNull
    private final ClientCardBufferRenderer clientCardBufferRenderer;
    @NotNull
    private final BingoHudState state;
    @NotNull
    private final BingoConfig config;

    public ClientCardManager(@NotNull Logger log, @NotNull IDrawServiceFactory drawServiceFactory, @NotNull ClientCardBufferRenderer clientCardBufferRenderer, @NotNull BingoHudState state, @NotNull BingoConfig config) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)drawServiceFactory, (String)"drawServiceFactory");
        Intrinsics.checkNotNullParameter((Object)clientCardBufferRenderer, (String)"clientCardBufferRenderer");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.log = log;
        this.drawServiceFactory = drawServiceFactory;
        this.clientCardBufferRenderer = clientCardBufferRenderer;
        this.state = state;
        this.config = config;
    }

    private final Pair<Integer, Integer> getCardSize(float cardScale) {
        int width = MathKt.roundToInt((double)((double)((float)122 * cardScale) * this.drawServiceFactory.getWindow().getScaleFactor()));
        int height = MathKt.roundToInt((double)((double)((float)132 * cardScale) * this.drawServiceFactory.getWindow().getScaleFactor()));
        return new Pair((Object)width, (Object)height);
    }

    @NotNull
    public final ClientCardBase newCard(@NotNull CardView view, float scale) {
        IFramebuffer iFramebuffer;
        Pair<Integer, Integer> pair;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Pair<Integer, Integer> pair2 = this.getCardSize(scale);
        int width = ((Number)pair2.component1()).intValue();
        int height = ((Number)pair2.component2()).intValue();
        Pair<Integer, Integer> it = pair = this.drawServiceFactory.newBuffer(width, height);
        boolean bl = false;
        it.register();
        Pair<Integer, Integer> framebuffer = pair;
        pair = this.getCardSize(1.0f);
        int guiWidth = ((Number)pair.component1()).intValue();
        int guiHeight = ((Number)pair.component2()).intValue();
        IFramebuffer it2 = iFramebuffer = this.drawServiceFactory.newBuffer(guiWidth, guiHeight);
        boolean bl2 = false;
        it2.register();
        IFramebuffer guiFramebuffer = iFramebuffer;
        return new ClientCardBase((IFramebuffer)framebuffer, view, null, null, null, null, false, false, guiFramebuffer, 252, null);
    }

    public static /* synthetic */ ClientCardBase newCard$default(ClientCardManager clientCardManager, CardView cardView, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = clientCardManager.config.getClient().getCardScale();
        }
        return clientCardManager.newCard(cardView, f);
    }

    public final void resizeCard(@NotNull ClientCard card, float scale) {
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        Pair<Integer, Integer> pair = this.getCardSize(scale);
        int width = ((Number)pair.component1()).intValue();
        int height = ((Number)pair.component2()).intValue();
        if (width != card.getFramebuffer().getWidth() || height != card.getFramebuffer().getHeight()) {
            card.getFramebuffer().resize(width, height);
            card.setDirty(true);
        }
    }

    public static /* synthetic */ void resizeCard$default(ClientCardManager clientCardManager, ClientCard clientCard, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = clientCardManager.config.getClient().getCardScale();
        }
        clientCardManager.resizeCard(clientCard, f);
    }

    public final void markDirty-2vhwn7g(@Nullable String key2) {
        block0: {
            String string = key2;
            ClientCardBase clientCardBase = this.state.getCards().get(string != null ? BingoTeamKey.box-impl(string) : null);
            if (clientCardBase == null) break block0;
            clientCardBase.setDirty(true);
        }
    }

    private final void updateCard(ClientCard card) {
        if (!this.drawServiceFactory.isBufferSupported()) {
            return;
        }
        card.getFramebuffer().write((Function1<? super IDrawService, Unit>)((Function1)arg_0 -> ClientCardManager.updateCard$lambda$0(this, card, arg_0)));
    }

    public final void updateCards() {
        for (ClientCardBase card : this.state.getCards().values()) {
            boolean isDirty = card.isDirty() || DurationKt.minus(this.state.getNow(), card.getShuffledAt()).compareTo(ClientCardBufferRenderer.Companion.getSHUFFLE_DURATION().plus(ClientCardBufferRenderer.Companion.getSHUFFLE_DURATION_PADDING())) < 0;
            if (!isDirty) continue;
            this.updateCard(card);
            this.updateCard(card.getGuiCard());
            card.setDirty(false);
            String string = card.getTeamKey-fzvlhXk();
            this.log.debug("[ClientCardManager] Card {} redrawn!", (Object)(string != null ? BingoTeamKey.box-impl(string) : null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit updateCard$lambda$0(ClientCardManager this$0, ClientCard $card, IDrawService drawService) {
        Intrinsics.checkNotNullParameter((Object)drawService, (String)"drawService");
        int originalWidth = ((Number)this$0.getCardSize(1.0f).component1()).intValue();
        float cardScale = (float)$card.getFramebuffer().getWidth() / (float)originalWidth;
        IMatrixStack $this$use$iv = drawService.getMatrices();
        boolean $i$f$use = false;
        try {
            $this$use$iv.push();
            IMatrixStack $this$updateCard_u24lambda_u240_u240 = $this$use$iv;
            boolean bl = false;
            $this$updateCard_u24lambda_u240_u240.scale(cardScale, cardScale, 1.0f);
            this$0.clientCardBufferRenderer.drawCard(drawService, $card);
        }
        finally {
            $this$use$iv.pop();
        }
        return Unit.INSTANCE;
    }
}

