/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.client.common.utils;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import me.jfenn.bingo.common.utils.DurationKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0019\u0018\u00002\u00020\u0001:\u0001(B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u000e\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J!\u0010\u0013\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\u000fJ\r\u0010\u0014\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0014\u0010\u0012R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\"\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010\u0015\u001a\u0004\b\u001a\u0010\u0017\"\u0004\b\u001b\u0010\u0019R\"\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0016\u0010&\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'\u00a8\u0006)"}, d2={"Lme/jfenn/bingo/client/common/utils/Interpolate;", "", "", "from", "to", "Ljava/time/Duration;", "duration", "Ljava/time/Instant;", "startedAt", "<init>", "(FFLjava/time/Duration;Ljava/time/Instant;)V", "Lme/jfenn/bingo/client/common/utils/Interpolate$Easing;", "easing", "now", "progress", "(Lme/jfenn/bingo/client/common/utils/Interpolate$Easing;Ljava/time/Instant;)F", "", "isDone", "()Z", "get", "update", "F", "getFrom", "()F", "setFrom", "(F)V", "getTo", "setTo", "Ljava/time/Duration;", "getDuration", "()Ljava/time/Duration;", "setDuration", "(Ljava/time/Duration;)V", "Ljava/time/Instant;", "getStartedAt", "()Ljava/time/Instant;", "setStartedAt", "(Ljava/time/Instant;)V", "isFinished", "Z", "Easing", "bingo-common_client"})
@Environment(value=EnvType.CLIENT)
public final class Interpolate {
    private float from;
    private float to;
    @NotNull
    private Duration duration;
    @NotNull
    private Instant startedAt;
    private boolean isFinished;

    public Interpolate(float from, float to, @NotNull Duration duration2, @NotNull Instant startedAt) {
        Intrinsics.checkNotNullParameter((Object)duration2, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)startedAt, (String)"startedAt");
        this.from = from;
        this.to = to;
        this.duration = duration2;
        this.startedAt = startedAt;
    }

    public /* synthetic */ Interpolate(float f, float f2, Duration duration2, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Duration duration3 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ZERO");
            duration2 = duration3;
        }
        if ((n & 8) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        this(f, f2, duration2, instant);
    }

    public final float getFrom() {
        return this.from;
    }

    public final void setFrom(float f) {
        this.from = f;
    }

    public final float getTo() {
        return this.to;
    }

    public final void setTo(float f) {
        this.to = f;
    }

    @NotNull
    public final Duration getDuration() {
        return this.duration;
    }

    public final void setDuration(@NotNull Duration duration2) {
        Intrinsics.checkNotNullParameter((Object)duration2, (String)"<set-?>");
        this.duration = duration2;
    }

    @NotNull
    public final Instant getStartedAt() {
        return this.startedAt;
    }

    public final void setStartedAt(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.startedAt = instant;
    }

    public final float progress(@NotNull Easing easing, @NotNull Instant now) {
        Intrinsics.checkNotNullParameter((Object)((Object)easing), (String)"easing");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        Duration animTimeSince = DurationKt.minus(now, this.startedAt);
        float progress = RangesKt.coerceIn((float)((float)DurationKt.div(animTimeSince, this.duration)), (float)0.0f, (float)1.0f);
        return switch (WhenMappings.$EnumSwitchMapping$0[easing.ordinal()]) {
            case 1 -> progress;
            case 2 -> -((float)(Math.cos(Math.PI * (double)Interpolate.progress$default(this, null, null, 3, null)) - 1.0)) / 2.0f;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ float progress$default(Interpolate interpolate, Easing easing, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            easing = Easing.LINEAR;
        }
        if ((n & 2) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        return interpolate.progress(easing, instant);
    }

    public final boolean isDone() {
        return Interpolate.progress$default(this, null, null, 3, null) > 0.9999f;
    }

    public final float get(@NotNull Easing easing, @NotNull Instant now) {
        Intrinsics.checkNotNullParameter((Object)((Object)easing), (String)"easing");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        float progress = this.progress(easing, now);
        return this.from * (1.0f - progress) + this.to * progress;
    }

    public static /* synthetic */ float get$default(Interpolate interpolate, Easing easing, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            easing = Easing.LINEAR;
        }
        if ((n & 2) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        return interpolate.get(easing, instant);
    }

    public final boolean update() {
        boolean ret = !this.isFinished;
        this.isFinished = this.isDone();
        return ret;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lme/jfenn/bingo/client/common/utils/Interpolate$Easing;", "", "<init>", "(Ljava/lang/String;I)V", "LINEAR", "IN_OUT", "bingo-common_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class Easing
    extends Enum<Easing> {
        public static final /* enum */ Easing LINEAR = new Easing();
        public static final /* enum */ Easing IN_OUT = new Easing();
        private static final /* synthetic */ Easing[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Easing[] values() {
            return (Easing[])$VALUES.clone();
        }

        public static Easing valueOf(String value) {
            return Enum.valueOf(Easing.class, value);
        }

        @NotNull
        public static EnumEntries<Easing> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = easingArray = new Easing[]{Easing.LINEAR, Easing.IN_OUT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    @Environment(value=EnvType.CLIENT)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Easing.values().length];
            try {
                nArray[Easing.LINEAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Easing.IN_OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

