/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.event.model.CardShuffledEvent;
import me.jfenn.bingo.common.event.model.StateChangedEvent;
import me.jfenn.bingo.common.event.model.TeamChangedEvent;
import me.jfenn.bingo.common.event.model.TeamWinnerEvent;
import me.jfenn.bingo.common.map.CardImageService;
import me.jfenn.bingo.common.map.CardViewService;
import me.jfenn.bingo.common.map.MapRenderService;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.PlayerEvent;
import me.jfenn.bingo.platform.event.model.ReloadEvent;
import me.jfenn.bingo.platform.event.model.TickEvent;
import me.jfenn.bingo.platform.item.IItemStackFactory;
import me.jfenn.bingo.platform.player.PlayerProfile;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0019R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001aR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001bR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u001cR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lme/jfenn/bingo/common/map/BingoMapController;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/common/map/CardViewService;", "cardViewService", "Lme/jfenn/bingo/common/map/CardImageService;", "cardImageService", "Lme/jfenn/bingo/common/map/MapRenderService;", "mapRenderService", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "itemStackFactory", "Lnet/minecraft/server/MinecraftServer;", "server", "<init>", "(Lme/jfenn/bingo/common/event/ScopedEvents;Lme/jfenn/bingo/platform/event/IEventBus;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/common/map/CardViewService;Lme/jfenn/bingo/common/map/CardImageService;Lme/jfenn/bingo/common/map/MapRenderService;Lme/jfenn/bingo/platform/item/IItemStackFactory;Lnet/minecraft/server/MinecraftServer;)V", "", "updateCards", "()V", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/common/map/CardViewService;", "Lme/jfenn/bingo/common/map/CardImageService;", "Lme/jfenn/bingo/common/map/MapRenderService;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nBingoMapController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BingoMapController.kt\nme/jfenn/bingo/common/map/BingoMapController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n774#2:104\n865#2,2:105\n1869#2,2:107\n1617#2,9:109\n1869#2:118\n1870#2:120\n1626#2:121\n1869#2,2:122\n1869#2,2:124\n1869#2,2:126\n1#3:119\n*S KotlinDebug\n*F\n+ 1 BingoMapController.kt\nme/jfenn/bingo/common/map/BingoMapController\n*L\n66#1:104\n66#1:105,2\n67#1:107,2\n72#1:109,9\n72#1:118\n72#1:120\n72#1:121\n73#1:122,2\n82#1:124,2\n89#1:126,2\n72#1:119\n*E\n"})
public final class BingoMapController
extends BingoComponent {
    @NotNull
    private final BingoState state;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final CardViewService cardViewService;
    @NotNull
    private final CardImageService cardImageService;
    @NotNull
    private final MapRenderService mapRenderService;

    public BingoMapController(@NotNull ScopedEvents events, @NotNull IEventBus eventBus, @NotNull BingoState state, @NotNull IPlayerManager playerManager, @NotNull CardViewService cardViewService, @NotNull CardImageService cardImageService, @NotNull MapRenderService mapRenderService, @NotNull IItemStackFactory itemStackFactory, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)cardViewService, (String)"cardViewService");
        Intrinsics.checkNotNullParameter((Object)cardImageService, (String)"cardImageService");
        Intrinsics.checkNotNullParameter((Object)mapRenderService, (String)"mapRenderService");
        Intrinsics.checkNotNullParameter((Object)itemStackFactory, (String)"itemStackFactory");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.state = state;
        this.playerManager = playerManager;
        this.cardViewService = cardViewService;
        this.cardImageService = cardImageService;
        this.mapRenderService = mapRenderService;
        this.mapRenderService.validateItems(itemStackFactory.listItems(server));
        eventBus.register(TickEvent.Start.INSTANCE, arg_0 -> BingoMapController._init_$lambda$0(this, arg_0));
        events.onPlayerJoin((Function1<? super PlayerEvent, Unit>)((Function1)arg_0 -> BingoMapController._init_$lambda$1(this, arg_0)));
        events.onPlayerChannelRegister((Function1<? super PlayerEvent, Unit>)((Function1)arg_0 -> BingoMapController._init_$lambda$2(this, arg_0)));
        events.onChangeTeam((Function1<? super TeamChangedEvent, Unit>)((Function1)arg_0 -> BingoMapController._init_$lambda$3(this, arg_0)));
        eventBus.register(TeamWinnerEvent.Companion, arg_0 -> BingoMapController._init_$lambda$4(this, arg_0));
        eventBus.register(CardShuffledEvent.Companion, arg_0 -> BingoMapController._init_$lambda$5(this, arg_0));
        events.onChangeOptions((Function1<? super Unit, Unit>)((Function1)arg_0 -> BingoMapController._init_$lambda$6(this, arg_0)));
        events.onStateChange((Function1<? super StateChangedEvent, Unit>)((Function1)arg_0 -> BingoMapController._init_$lambda$7(this, arg_0)));
        eventBus.register(ReloadEvent.After.Companion, arg_0 -> BingoMapController._init_$lambda$8(this, arg_0));
    }

    private final void updateCards() {
        if (this.state.getState() == GameState.PREGAME) {
            CardViewService.updateCard$default(this.cardViewService, null, false, 2, null);
        }
        for (BingoTeam team : this.state.getRegisteredTeams()) {
            CardViewService.updateCard$default(this.cardViewService, team, false, 2, null);
        }
    }

    private static final Unit _init_$lambda$0(BingoMapController this$0, TickEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.cardImageService.sendNecessaryImages();
        this$0.updateCards();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(BingoMapController this$0, PlayerEvent playerEvent) {
        Intrinsics.checkNotNullParameter((Object)playerEvent, (String)"<destruct>");
        IPlayerHandle player = playerEvent.component1();
        this$0.cardImageService.clearPlayerState(player.getUuid());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(BingoMapController this$0, PlayerEvent playerEvent) {
        Intrinsics.checkNotNullParameter((Object)playerEvent, (String)"<destruct>");
        IPlayerHandle player = playerEvent.component1();
        this$0.cardViewService.sendUpdatePackets(player);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$3(BingoMapController this$0, TeamChangedEvent event) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this$0.cardViewService.sendClearDisplayPacket(event.getPlayer());
        this$0.cardViewService.sendUpdatePackets(event.getPlayer());
        Iterable $this$filter$iv = this$0.playerManager.getPlayers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IPlayerHandle it = (IPlayerHandle)element$iv$iv;
            boolean bl = false;
            if (!this$0.cardViewService.isViewingSpectatorCards(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IPlayerHandle it = (IPlayerHandle)element$iv;
            boolean bl = false;
            this$0.cardViewService.sendUpdatePackets(it);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$4(BingoMapController this$0, TeamWinnerEvent event) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$mapNotNull$iv = event.getTeam().getPlayers();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            IPlayerHandle it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PlayerProfile it = (PlayerProfile)element$iv$iv;
            boolean bl2 = false;
            if (this$0.playerManager.getPlayer(it.getUuid()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            IPlayerHandle it = (IPlayerHandle)element$iv;
            boolean bl = false;
            this$0.cardViewService.sendUpdatePackets(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(BingoMapController this$0, CardShuffledEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.cardViewService.sendCardShuffledPacket(it.getCardId());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(BingoMapController this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateCards();
        Iterable $this$forEach$iv = this$0.playerManager.getPlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IPlayerHandle it2 = (IPlayerHandle)element$iv;
            boolean bl = false;
            this$0.cardViewService.sendUpdatePackets(it2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(BingoMapController this$0, StateChangedEvent stateChangedEvent) {
        Intrinsics.checkNotNullParameter((Object)stateChangedEvent, (String)"<destruct>");
        GameState to = stateChangedEvent.component2();
        List<IPlayerHandle> players = this$0.playerManager.getPlayers();
        if (to == GameState.PREGAME && this$0.state.isLobbyMode()) {
            Iterable $this$forEach$iv = players;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IPlayerHandle it = (IPlayerHandle)element$iv;
                boolean bl = false;
                this$0.cardViewService.sendClearDisplayPacket(it);
            }
        }
        this$0.updateCards();
        for (IPlayerHandle player : this$0.playerManager.getPlayers()) {
            this$0.cardViewService.sendUpdatePackets(player);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$8(BingoMapController this$0, ReloadEvent.After it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.cardImageService.clearPlayerStates();
        this$0.mapRenderService.clearCache();
        return Unit.INSTANCE;
    }
}

