/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.stats;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import me.jfenn.bingo.common.ConstantsKt;
import me.jfenn.bingo.common.data.ScopedData;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.stats.CommonKt;
import me.jfenn.bingo.common.stats.StatsService;
import me.jfenn.bingo.common.stats.data.PlayerStatsSummary;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.common.utils.DurationKt;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.platform.EntityType;
import me.jfenn.bingo.platform.IArmorStandEntity;
import me.jfenn.bingo.platform.IEntity;
import me.jfenn.bingo.platform.IEntityManager;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.ITextDisplayEntity;
import me.jfenn.bingo.platform.event.model.TickEvent;
import me.jfenn.bingo.platform.item.IItemStackFactory;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_124;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 O2\u00020\u0001:\u0001OBW\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J#\u0010\u001e\u001a\u00020\u001d*\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0011\u0010!\u001a\u0004\u0018\u00010 H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010'\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020#2\u0006\u0010&\u001a\u00020%H\u0002\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010)\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010,\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020+H\u0002\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010.\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b.\u0010*J\u000f\u0010/\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b/\u0010*R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00100R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00101R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00102R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u00103R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00104R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u00105R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u00106R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u00107R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u00108R\u0018\u0010:\u001a\u0004\u0018\u0001098\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0016\u0010=\u001a\u00020<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u001e\u0010@\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010?8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010AR\u0018\u0010B\u001a\u0004\u0018\u00010\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0018\u0010D\u001a\u0004\u0018\u0001098\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010;R\u0016\u0010H\u001a\u0004\u0018\u00010E8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR\u0018\u0010I\u001a\u0004\u0018\u0001098\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bI\u0010;R\u0016\u0010K\u001a\u0004\u0018\u00010E8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010GR\u0018\u0010L\u001a\u0004\u0018\u0001098\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bL\u0010;R\u0016\u0010N\u001a\u0004\u0018\u00010E8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010G\u00a8\u0006P"}, d2={"Lme/jfenn/bingo/common/stats/StatsLobbyController;", "", "Lorg/slf4j/Logger;", "log", "Lnet/minecraft/server/MinecraftServer;", "server", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/data/ScopedData;", "data", "Lme/jfenn/bingo/common/stats/StatsService;", "stats", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "itemStackFactory", "Lme/jfenn/bingo/platform/IEntityManager;", "entityManager", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "<init>", "(Lorg/slf4j/Logger;Lnet/minecraft/server/MinecraftServer;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/data/ScopedData;Lme/jfenn/bingo/common/stats/StatsService;Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/platform/item/IItemStackFactory;Lme/jfenn/bingo/platform/IEntityManager;Lme/jfenn/bingo/common/event/ScopedEvents;)V", "Lme/jfenn/bingo/platform/IEntity;", "Lorg/joml/Matrix4f;", "matrix", "Lorg/joml/Vector3d;", "pos", "", "transformPos", "(Lme/jfenn/bingo/platform/IEntity;Lorg/joml/Matrix4f;Lorg/joml/Vector3d;)V", "Lme/jfenn/bingo/platform/IArmorStandEntity;", "getArmorStand", "()Lme/jfenn/bingo/platform/IArmorStandEntity;", "Lnet/minecraft/class_3222;", "player", "Lme/jfenn/bingo/common/stats/data/PlayerStatsSummary;", "summary", "spawnSummary", "(Lnet/minecraft/class_3222;Lme/jfenn/bingo/common/stats/data/PlayerStatsSummary;)V", "resetSummary", "()V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "tickPlayer", "(Lme/jfenn/bingo/platform/IPlayerHandle;)V", "tickPlayers", "tickStats", "Lorg/slf4j/Logger;", "Lnet/minecraft/server/MinecraftServer;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/data/ScopedData;", "Lme/jfenn/bingo/common/stats/StatsService;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "Lme/jfenn/bingo/platform/IEntityManager;", "Ljava/util/UUID;", "showingPlayer", "Ljava/util/UUID;", "Ljava/time/Instant;", "showingStartedAt", "Ljava/time/Instant;", "Ljava/util/concurrent/CompletableFuture;", "pendingStats", "Ljava/util/concurrent/CompletableFuture;", "statsTransform", "Lorg/joml/Matrix4f;", "nameEntityUuid", "Lme/jfenn/bingo/platform/ITextDisplayEntity;", "getNameEntity", "()Lme/jfenn/bingo/platform/ITextDisplayEntity;", "nameEntity", "leftEntityUuid", "getLeftEntity", "leftEntity", "rightEntityUuid", "getRightEntity", "rightEntity", "Companion", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nStatsLobbyController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatsLobbyController.kt\nme/jfenn/bingo/common/stats/StatsLobbyController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Duration.kt\nme/jfenn/bingo/common/utils/DurationKt\n*L\n1#1,355:1\n1#2:356\n774#3:357\n865#3,2:358\n65#4:360\n65#4:361\n*S KotlinDebug\n*F\n+ 1 StatsLobbyController.kt\nme/jfenn/bingo/common/stats/StatsLobbyController\n*L\n316#1:357\n316#1:358,2\n44#1:360\n45#1:361\n*E\n"})
public final class StatsLobbyController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger log;
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final BingoState state;
    @NotNull
    private final ScopedData data;
    @NotNull
    private final StatsService stats;
    @NotNull
    private final TextProvider text;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final IItemStackFactory itemStackFactory;
    @NotNull
    private final IEntityManager entityManager;
    @Nullable
    private UUID showingPlayer;
    @NotNull
    private Instant showingStartedAt;
    @Nullable
    private CompletableFuture<PlayerStatsSummary> pendingStats;
    @Nullable
    private Matrix4f statsTransform;
    @Nullable
    private UUID nameEntityUuid;
    @Nullable
    private UUID leftEntityUuid;
    @Nullable
    private UUID rightEntityUuid;
    @NotNull
    private static final Duration DURATION_DELAY;
    @NotNull
    private static final Duration DURATION_RESET;

    public StatsLobbyController(@NotNull Logger log, @NotNull MinecraftServer server, @NotNull BingoState state, @NotNull ScopedData data, @NotNull StatsService stats, @NotNull TextProvider text, @NotNull IPlayerManager playerManager, @NotNull IItemStackFactory itemStackFactory, @NotNull IEntityManager entityManager, @NotNull ScopedEvents events) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)itemStackFactory, (String)"itemStackFactory");
        Intrinsics.checkNotNullParameter((Object)entityManager, (String)"entityManager");
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        this.log = log;
        this.server = server;
        this.state = state;
        this.data = data;
        this.stats = stats;
        this.text = text;
        this.playerManager = playerManager;
        this.itemStackFactory = itemStackFactory;
        this.entityManager = entityManager;
        Instant instant = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"MIN");
        this.showingStartedAt = instant;
        events.onGameTick((Function1<? super TickEvent, Unit>)((Function1)arg_0 -> StatsLobbyController._init_$lambda$0(this, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final void transformPos(IEntity $this$transformPos, Matrix4f matrix, Vector3d pos) {
        void it;
        Vector3d $this$transformPos_u24lambda_u240 = pos;
        boolean $i$a$-with-StatsLobbyController$transformPos$pos4f$22 = false;
        Vector4f pos4f = new Vector4f((float)$this$transformPos_u24lambda_u240.x, (float)$this$transformPos_u24lambda_u240.y, (float)$this$transformPos_u24lambda_u240.z, 1.0f);
        Vector4f $i$a$-with-StatsLobbyController$transformPos$pos4f$22 = matrix.transform(pos4f);
        IEntity iEntity = $this$transformPos;
        boolean bl = false;
        iEntity.setPos(new Vector3d((double)it.x, (double)it.y, (double)it.z));
        Vector3f angles = new Vector3f();
        matrix.getEulerAnglesXYZ(angles);
        $this$transformPos.setYaw($this$transformPos.getYaw() + (float)Math.toDegrees(-((double)angles.y)));
    }

    private final ITextDisplayEntity getNameEntity() {
        ITextDisplayEntity iTextDisplayEntity;
        Object it;
        class_3218 class_32182 = ConstantsKt.getLobbyWorld(this.server);
        if (class_32182 == null) {
            return null;
        }
        class_3218 lobbyWorld = class_32182;
        UUID uUID = this.nameEntityUuid;
        if (uUID != null) {
            it = uUID;
            boolean bl = false;
            IEntity iEntity = this.entityManager.getEntity(lobbyWorld, (UUID)it);
            ITextDisplayEntity iTextDisplayEntity2 = iEntity instanceof ITextDisplayEntity ? (ITextDisplayEntity)iEntity : null;
            if (iTextDisplayEntity2 != null) {
                it = iTextDisplayEntity2;
                boolean bl2 = false;
                return it;
            }
        }
        Matrix4f matrix4f = this.statsTransform;
        if (matrix4f == null) {
            return null;
        }
        Matrix4f transform = matrix4f;
        ITextDisplayEntity $this$_get_nameEntity__u24lambda_u242 = iTextDisplayEntity = this.entityManager.createEntity(EntityType.Companion.getTEXT_DISPLAY(), lobbyWorld);
        boolean bl = false;
        this.transformPos($this$_get_nameEntity__u24lambda_u242, transform, new Vector3d(0.0, 2.2, 0.0));
        $this$_get_nameEntity__u24lambda_u242.setValue(this.text.empty());
        $this$_get_nameEntity__u24lambda_u242.setBillboard(ITextDisplayEntity.Billboard.FIXED);
        $this$_get_nameEntity__u24lambda_u242.setAlignment(ITextDisplayEntity.TextAlignment.RIGHT);
        $this$_get_nameEntity__u24lambda_u242.setBackground(Integer.MIN_VALUE);
        it = iTextDisplayEntity;
        boolean bl3 = false;
        this.entityManager.spawnEntity(lobbyWorld, (IEntity)it);
        ITextDisplayEntity entity = iTextDisplayEntity;
        this.nameEntityUuid = entity.getUuid();
        return entity;
    }

    private final ITextDisplayEntity getLeftEntity() {
        ITextDisplayEntity iTextDisplayEntity;
        Object it;
        class_3218 class_32182 = ConstantsKt.getLobbyWorld(this.server);
        if (class_32182 == null) {
            return null;
        }
        class_3218 lobbyWorld = class_32182;
        UUID uUID = this.leftEntityUuid;
        if (uUID != null) {
            it = uUID;
            boolean bl = false;
            IEntity iEntity = this.entityManager.getEntity(lobbyWorld, (UUID)it);
            ITextDisplayEntity iTextDisplayEntity2 = iEntity instanceof ITextDisplayEntity ? (ITextDisplayEntity)iEntity : null;
            if (iTextDisplayEntity2 != null) {
                it = iTextDisplayEntity2;
                boolean bl2 = false;
                return it;
            }
        }
        Matrix4f matrix4f = this.statsTransform;
        if (matrix4f == null) {
            return null;
        }
        Matrix4f transform = matrix4f;
        ITextDisplayEntity $this$_get_leftEntity__u24lambda_u242 = iTextDisplayEntity = this.entityManager.createEntity(EntityType.Companion.getTEXT_DISPLAY(), lobbyWorld);
        boolean bl = false;
        this.transformPos($this$_get_leftEntity__u24lambda_u242, transform, new Vector3d(-1.8, 0.5, 0.0));
        $this$_get_leftEntity__u24lambda_u242.setValue(this.text.empty());
        $this$_get_leftEntity__u24lambda_u242.setBillboard(ITextDisplayEntity.Billboard.FIXED);
        $this$_get_leftEntity__u24lambda_u242.setAlignment(ITextDisplayEntity.TextAlignment.RIGHT);
        $this$_get_leftEntity__u24lambda_u242.setBackground(-1342177280);
        Matrix4f matrix4f2 = new Matrix4f().scale(0.5f);
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f2, (String)"scale(...)");
        $this$_get_leftEntity__u24lambda_u242.setTransformation(matrix4f2);
        it = iTextDisplayEntity;
        boolean bl3 = false;
        this.entityManager.spawnEntity(lobbyWorld, (IEntity)it);
        ITextDisplayEntity entity = iTextDisplayEntity;
        this.leftEntityUuid = entity.getUuid();
        return entity;
    }

    private final ITextDisplayEntity getRightEntity() {
        ITextDisplayEntity iTextDisplayEntity;
        Object it;
        class_3218 class_32182 = ConstantsKt.getLobbyWorld(this.server);
        if (class_32182 == null) {
            return null;
        }
        class_3218 lobbyWorld = class_32182;
        UUID uUID = this.rightEntityUuid;
        if (uUID != null) {
            it = uUID;
            boolean bl = false;
            IEntity iEntity = this.entityManager.getEntity(lobbyWorld, (UUID)it);
            ITextDisplayEntity iTextDisplayEntity2 = iEntity instanceof ITextDisplayEntity ? (ITextDisplayEntity)iEntity : null;
            if (iTextDisplayEntity2 != null) {
                it = iTextDisplayEntity2;
                boolean bl2 = false;
                return it;
            }
        }
        Matrix4f matrix4f = this.statsTransform;
        if (matrix4f == null) {
            return null;
        }
        Matrix4f transform = matrix4f;
        ITextDisplayEntity $this$_get_rightEntity__u24lambda_u242 = iTextDisplayEntity = this.entityManager.createEntity(EntityType.Companion.getTEXT_DISPLAY(), lobbyWorld);
        boolean bl = false;
        this.transformPos($this$_get_rightEntity__u24lambda_u242, transform, new Vector3d(1.8, 0.5, 0.0));
        $this$_get_rightEntity__u24lambda_u242.setValue(this.text.empty());
        $this$_get_rightEntity__u24lambda_u242.setBillboard(ITextDisplayEntity.Billboard.FIXED);
        $this$_get_rightEntity__u24lambda_u242.setAlignment(ITextDisplayEntity.TextAlignment.LEFT);
        $this$_get_rightEntity__u24lambda_u242.setBackground(-1342177280);
        Matrix4f matrix4f2 = new Matrix4f().scale(0.5f);
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f2, (String)"scale(...)");
        $this$_get_rightEntity__u24lambda_u242.setTransformation(matrix4f2);
        it = iTextDisplayEntity;
        boolean bl3 = false;
        this.entityManager.spawnEntity(lobbyWorld, (IEntity)it);
        ITextDisplayEntity entity = iTextDisplayEntity;
        this.rightEntityUuid = entity.getUuid();
        return entity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final IArmorStandEntity getArmorStand() {
        class_3218 class_32182 = ConstantsKt.getLobbyWorld(this.server);
        if (class_32182 == null) return null;
        class_3218 it = class_32182;
        boolean bl = false;
        Sequence<IEntity> sequence = this.entityManager.iterateEntities(it);
        if (sequence == null) return null;
        Sequence sequence2 = SequencesKt.mapNotNull(sequence, StatsLobbyController::getArmorStand$lambda$1);
        if (sequence2 == null) return null;
        IArmorStandEntity iArmorStandEntity = (IArmorStandEntity)SequencesKt.firstOrNull((Sequence)sequence2);
        return iArmorStandEntity;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void spawnSummary(class_3222 player, PlayerStatsSummary summary) {
        block12: {
            armorStand = this.getArmorStand();
            if (armorStand == null) {
                this.log.warn("[StatsLobbyController] Could not display player stats; no armor stand found");
                return;
            }
            var5_4 = armorStand.getPos();
            var16_5 = new Matrix4f();
            var15_6 = this;
            $i$a$-let-StatsLobbyController$spawnSummary$1 = false;
            var17_9 = new Vector3f((float)it.x, (float)it.y, (float)it.z);
            var15_6.statsTransform = var16_5.translate((Vector3fc)var17_9).rotateY((float)Math.toRadians(-((double)armorStand.getYaw())));
            playerHead = this.itemStackFactory.createPlayerHead();
            playerHead.setSkullOwner(player);
            armorStand.equipStack(IArmorStandEntity.EquipmentSlot.HEAD, playerHead);
            v0 = this.getNameEntity();
            if (v0 != null) {
                v0.setValue(this.text.literal(this.playerManager.forPlayer(player).getPlayerName()));
            }
            $i$a$-let-StatsLobbyController$spawnSummary$1 = summary.getFavoriteTeam-fzvlhXk();
            if ($i$a$-let-StatsLobbyController$spawnSummary$1 == null) ** GOTO lbl-1000
            it = $i$a$-let-StatsLobbyController$spawnSummary$1;
            $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$1 = false;
            var7_16 = this.data.getTeamPresets().get(BingoTeamKey.box-impl(it));
            if (var7_16 == null) ** GOTO lbl-1000
            it = var7_16;
            $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$2 = false;
            var8_21 = BingoTeam.Companion.fromPreset-3J0cPAY(summary.getFavoriteTeam-fzvlhXk(), it);
            if (var8_21 != null) {
                team = var8_21;
                $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 = false;
                v1 = this.text.empty().append(BingoTeam.getName$default((BingoTeam)team, this.text, false, true, false, null, 2, null)).append(" (" + (int)(summary.getFavoriteTeamPercentage() * 100.0f) + "%)");
            } else lbl-1000:
            // 3 sources

            {
                v1 = null;
            }
            favoriteTeam = v1;
            divider = this.text.literal(StringsKt.repeat((CharSequence)"\ud83e\udf2d", (int)28));
            var8_21 = CollectionsKt.createListBuilder();
            $this$spawnSummary_u24lambda_u244 = var8_21;
            $i$a$-buildList-StatsLobbyController$spawnSummary$allTimeStats$1 = false;
            $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */  = new class_124[]{class_124.field_1067, class_124.field_1054};
            $this$spawnSummary_u24lambda_u244.add(this.text.string(StringKey.StatsAllTime).append(" \u2605").formatted($i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */ ));
            $this$spawnSummary_u24lambda_u244.add(divider);
            $this$spawnSummary_u24lambda_u244.add(this.text.empty());
            $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */  = new class_124[]{class_124.field_1067, class_124.field_1080};
            $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */  = this.text.empty().append(this.text.string(StringKey.StatsGames).formatted($i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */ )).append(": " + CommonKt.formatLargeNumber(summary.getTotalGames()));
            it = $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */ ;
            $i$a$-also-StatsLobbyController$spawnSummary$allTimeStats$1$1 = false;
            $this$spawnSummary_u24lambda_u244.add(it);
            $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */  = new class_124[]{class_124.field_1067, class_124.field_1080};
            $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */  = this.text.empty().append(this.text.string(StringKey.StatsWinLoss).formatted($i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */ )).append(": " + CommonKt.formatLargeNumber(summary.getTotalWins()) + "/" + CommonKt.formatLargeNumber(summary.getTotalLosses()));
            it = $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */ ;
            $i$a$-also-StatsLobbyController$spawnSummary$allTimeStats$1$2 = false;
            $this$spawnSummary_u24lambda_u244.add(it);
            $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */  = new class_124[]{class_124.field_1067, class_124.field_1080};
            $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */  = this.text.empty().append(this.text.string(StringKey.StatsItems).formatted($i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */ )).append(": " + CommonKt.formatLargeNumber(summary.getTotalItems()));
            it = $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */ ;
            $i$a$-also-StatsLobbyController$spawnSummary$allTimeStats$1$3 = false;
            $this$spawnSummary_u24lambda_u244.add(it);
            $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */  = new class_124[]{class_124.field_1067, class_124.field_1080};
            $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */  = this.text.empty().append(this.text.string(StringKey.StatsPlaytime).formatted($i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */ )).append(": " + DurationKt.formatString(summary.getTotalPlaytime()));
            it = $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */ ;
            $i$a$-also-StatsLobbyController$spawnSummary$allTimeStats$1$4 = false;
            $this$spawnSummary_u24lambda_u244.add(it);
            $this$spawnSummary_u24lambda_u244.add(this.text.empty());
            $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */  = new class_124[]{class_124.field_1067, class_124.field_1080};
            $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */  = this.text.empty().append(this.text.string(StringKey.StatsFavoriteTeam).formatted($i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */ )).append(":");
            it = $i$a$-let-StatsLobbyController$spawnSummary$favoriteTeam$3 /* !! */ ;
            $i$a$-also-StatsLobbyController$spawnSummary$allTimeStats$1$5 = false;
            $this$spawnSummary_u24lambda_u244.add(it);
            v2 = favoriteTeam;
            if (v2 == null) {
                v2 = this.text.literal("-");
            }
            $this$spawnSummary_u24lambda_u244.add(v2);
            allTimeStats = CollectionsKt.toMutableList((Collection)CollectionsKt.build((List)var8_21));
            $this$spawnSummary_u24lambda_u245 = $this$spawnSummary_u24lambda_u244 = CollectionsKt.createListBuilder();
            $i$a$-buildList-StatsLobbyController$spawnSummary$monthlyStats$1 = false;
            it = new class_124[]{class_124.field_1067, class_124.field_1075};
            $this$spawnSummary_u24lambda_u245.add(this.text.literal("\ud83d\udcc6 ").append(this.text.string(StringKey.StatsMonthly)).formatted((class_124[])it));
            $this$spawnSummary_u24lambda_u245.add(divider);
            $this$spawnSummary_u24lambda_u245.add(this.text.empty());
            it = new class_124[]{class_124.field_1067, class_124.field_1080};
            it = this.text.empty().append(this.text.string(StringKey.StatsGames).formatted((class_124[])it)).append(": " + CommonKt.formatLargeNumber(summary.getMonthlyGames()));
            it /* !! */  = it;
            $i$a$-also-StatsLobbyController$spawnSummary$monthlyStats$1$1 = false;
            $this$spawnSummary_u24lambda_u245.add(it /* !! */ );
            it = new class_124[]{class_124.field_1067, class_124.field_1080};
            it = this.text.empty().append(this.text.string(StringKey.StatsWinLoss).formatted((class_124[])it)).append(": " + CommonKt.formatLargeNumber(summary.getMonthlyWins()) + "/" + CommonKt.formatLargeNumber(summary.getMonthlyLosses()));
            it /* !! */  = it;
            $i$a$-also-StatsLobbyController$spawnSummary$monthlyStats$1$2 = false;
            $this$spawnSummary_u24lambda_u245.add(it /* !! */ );
            it = new class_124[]{class_124.field_1067, class_124.field_1080};
            it = this.text.empty().append(this.text.string(StringKey.StatsItems).formatted((class_124[])it)).append(": " + CommonKt.formatLargeNumber(summary.getMonthlyItems()));
            it /* !! */  = it;
            $i$a$-also-StatsLobbyController$spawnSummary$monthlyStats$1$3 = false;
            $this$spawnSummary_u24lambda_u245.add(it /* !! */ );
            it = new class_124[]{class_124.field_1067, class_124.field_1080};
            it = this.text.empty().append(this.text.string(StringKey.StatsPlaytime).formatted((class_124[])it)).append(": " + DurationKt.formatString(summary.getMonthlyPlaytime()));
            it /* !! */  = it;
            $i$a$-also-StatsLobbyController$spawnSummary$monthlyStats$1$4 = false;
            $this$spawnSummary_u24lambda_u245.add(it /* !! */ );
            $this$spawnSummary_u24lambda_u245.add(this.text.empty());
            it = new class_124[]{class_124.field_1067, class_124.field_1080};
            v3 = this.text.empty().append(this.text.string(StringKey.StatsWinStreak).formatted((class_124[])it)).append(": ");
            if (summary.getWinStreakBest() != null) {
                it = new Object[]{summary.getWinStreak(), summary.getWinStreakBest()};
                v4 = this.text.string(StringKey.StatsWinStreakValue, it);
            } else {
                v4 = this.text.literal(String.valueOf(summary.getWinStreak()));
            }
            it = v3.append(v4);
            it /* !! */  = it;
            $i$a$-also-StatsLobbyController$spawnSummary$monthlyStats$1$5 = false;
            $this$spawnSummary_u24lambda_u245.add(it /* !! */ );
            monthlyStats = CollectionsKt.toMutableList((Collection)CollectionsKt.build((List)$this$spawnSummary_u24lambda_u244));
            while (allTimeStats.size() < monthlyStats.size()) {
                allTimeStats.add(this.text.empty());
            }
            while (monthlyStats.size() < allTimeStats.size()) {
                monthlyStats.add(this.text.empty());
            }
            margin = StringsKt.repeat((CharSequence)" ", (int)4);
            text = var10_15 = this.text.literal("\n");
            $i$a$-also-StatsLobbyController$spawnSummary$2 = false;
            for (IText t : allTimeStats) {
                text.append(margin).append(t).append(margin + "\n");
            }
            it = var10_15;
            $i$a$-let-StatsLobbyController$spawnSummary$3 = false;
            v5 = this.getLeftEntity();
            if (v5 != null) {
                v5.setValue(it);
            }
            text = var10_15 = this.text.literal("\n");
            $i$a$-also-StatsLobbyController$spawnSummary$4 = false;
            for (IText t : monthlyStats) {
                text.append(margin).append(t).append(margin + "\n");
            }
            it = var10_15;
            $i$a$-let-StatsLobbyController$spawnSummary$5 = false;
            v6 = this.getRightEntity();
            if (v6 == null) break block12;
            v6.setValue(it);
        }
    }

    private final void resetSummary() {
        block3: {
            ITextDisplayEntity iTextDisplayEntity = this.getLeftEntity();
            if (iTextDisplayEntity != null) {
                iTextDisplayEntity.setValue(this.text.empty());
            }
            ITextDisplayEntity iTextDisplayEntity2 = this.getRightEntity();
            if (iTextDisplayEntity2 != null) {
                iTextDisplayEntity2.setValue(this.text.empty());
            }
            ITextDisplayEntity iTextDisplayEntity3 = this.getNameEntity();
            if (iTextDisplayEntity3 != null) {
                iTextDisplayEntity3.setValue(this.text.empty());
            }
            IArmorStandEntity iArmorStandEntity = this.getArmorStand();
            if (iArmorStandEntity == null) break block3;
            iArmorStandEntity.equipStack(IArmorStandEntity.EquipmentSlot.HEAD, this.itemStackFactory.getEmptyStack());
        }
    }

    private final void tickPlayer(IPlayerHandle player) {
        Instant now = Instant.now();
        if (Intrinsics.areEqual((Object)this.showingPlayer, (Object)player.getUuid())) {
            Intrinsics.checkNotNull((Object)now);
            this.showingStartedAt = now;
            return;
        }
        Intrinsics.checkNotNull((Object)now);
        if (DurationKt.minus(now, this.showingStartedAt).compareTo(DURATION_DELAY) < 0) {
            return;
        }
        this.log.info("[StatsLobbyController] Fetching summary for player " + player.getUuid() + "...");
        this.showingPlayer = player.getUuid();
        this.showingStartedAt = now;
        this.pendingStats = this.stats.getPlayerSummaryAsync(player.getUuid());
    }

    /*
     * WARNING - void declaration
     */
    private final void tickPlayers() {
        Object v0;
        block4: {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.playerManager.getPlayers();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IPlayerHandle it = (IPlayerHandle)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getWorld().getIdentifier(), (Object)ConstantsKt.getLOBBY_WORLD_ID().toString())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                IPlayerHandle player = (IPlayerHandle)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)player.getWorld().getBlockState(player.getBlockPos()).getIdentifier(), (Object)"minecraft:heavy_weighted_pressure_plate")) continue;
                v0 = e;
                break block4;
            }
            v0 = null;
        }
        IPlayerHandle player = v0;
        if (player != null) {
            this.tickPlayer(player);
            return;
        }
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        if (DurationKt.minus(instant, this.showingStartedAt).compareTo(DURATION_RESET) > 0 && this.showingPlayer != null) {
            this.showingPlayer = null;
            this.resetSummary();
        }
    }

    private final void tickStats() {
        class_3222 class_32222;
        PlayerStatsSummary result;
        block7: {
            block6: {
                CompletableFuture<PlayerStatsSummary> completableFuture = this.pendingStats;
                if (completableFuture == null) {
                    return;
                }
                CompletableFuture<PlayerStatsSummary> pending = completableFuture;
                if (!pending.isDone()) {
                    return;
                }
                this.pendingStats = null;
                PlayerStatsSummary playerStatsSummary = pending.getNow(null);
                if (playerStatsSummary == null) {
                    return;
                }
                result = playerStatsSummary;
                UUID uUID = this.showingPlayer;
                if (uUID == null) break block6;
                UUID it = uUID;
                boolean bl = false;
                class_32222 = this.server.method_3760().method_14602(it);
                if (class_32222 != null) break block7;
            }
            return;
        }
        class_3222 player = class_32222;
        this.log.info("[StatsLobbyController] Finished fetching player summary!");
        this.spawnSummary(player, result);
    }

    private static final IArmorStandEntity getArmorStand$lambda$1(IEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof IArmorStandEntity ? (IArmorStandEntity)it : null;
    }

    private static final Unit _init_$lambda$0(StatsLobbyController this$0, TickEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.state.getState() != GameState.PREGAME) {
            return Unit.INSTANCE;
        }
        this$0.tickPlayers();
        this$0.tickStats();
        return Unit.INSTANCE;
    }

    static {
        int $this$seconds$iv = 5;
        boolean $i$f$getSeconds = false;
        Duration duration2 = Duration.ofSeconds($this$seconds$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        DURATION_DELAY = duration2;
        $this$seconds$iv = 10;
        $i$f$getSeconds = false;
        Duration duration3 = Duration.ofSeconds($this$seconds$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(...)");
        DURATION_RESET = duration3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006\u00a8\u0006\b"}, d2={"Lme/jfenn/bingo/common/stats/StatsLobbyController$Companion;", "", "<init>", "()V", "Ljava/time/Duration;", "DURATION_DELAY", "Ljava/time/Duration;", "DURATION_RESET", "bingo-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

