/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.mixinhandler;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.jfenn.bingo.common.ConstantsKt;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.spawn.SpawnData;
import me.jfenn.bingo.common.spawn.SpawnService;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.IServerWorld;
import me.jfenn.bingo.platform.block.BlockPosition;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.game.ScopeStopped;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 \"2\u00020\u0001:\u0001\"B9\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0012J\r\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0017\u0010\u0012J\u0015\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001eR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001fR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010 R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010!\u00a8\u0006#"}, d2={"Lme/jfenn/bingo/mixinhandler/PlayerManagerMixinHelper;", "", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/spawn/SpawnService;", "spawnService", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "<init>", "(Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/spawn/SpawnService;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/platform/event/IEventBus;)V", "", "shouldPreventLobbyChaos", "()Z", "shouldSpawnInLobby", "Lme/jfenn/bingo/common/spawn/SpawnData;", "getPregameSpawnData", "()Lme/jfenn/bingo/common/spawn/SpawnData;", "shouldOverrideEndRespawn", "Lnet/minecraft/class_3222;", "serverPlayerEntity", "", "setPlayerSpawnpoint", "(Lnet/minecraft/class_3222;)V", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/spawn/SpawnService;", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Companion", "bingo-common"})
public final class PlayerManagerMixinHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final BingoState state;
    @NotNull
    private final SpawnService spawnService;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final IPlayerManager playerManager;
    @Nullable
    private static PlayerManagerMixinHelper instance;

    public PlayerManagerMixinHelper(@NotNull BingoConfig config, @NotNull BingoState state, @NotNull SpawnService spawnService, @NotNull TeamService teamService, @NotNull IPlayerManager playerManager, @NotNull IEventBus eventBus) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)spawnService, (String)"spawnService");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.config = config;
        this.state = state;
        this.spawnService = spawnService;
        this.teamService = teamService;
        this.playerManager = playerManager;
        instance = this;
        eventBus.register(ScopeStopped.Companion, PlayerManagerMixinHelper::_init_$lambda$0);
    }

    public final boolean shouldPreventLobbyChaos() {
        return this.config.getPreventLobbyChaos() && this.state.getState() == GameState.PREGAME;
    }

    public final boolean shouldSpawnInLobby() {
        return this.state.isLobbyMode() && (this.state.getState() == GameState.PREGAME || this.state.getState() == GameState.PRELOADING);
    }

    @NotNull
    public final SpawnData getPregameSpawnData() {
        String string = ConstantsKt.getLOBBY_WORLD_ID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new SpawnData(string, this.state.getLobbySpawnPos(), this.state.getLobbySpawnYaw());
    }

    public final boolean shouldOverrideEndRespawn() {
        IServerWorld dimension = this.spawnService.getSpawnDimension();
        return this.state.isLobbyMode() && Intrinsics.areEqual((Object)StringsKt.substringAfter$default((String)dimension.getIdentifier(), (char)':', null, (int)2, null), (Object)"the_end");
    }

    public final void setPlayerSpawnpoint(@NotNull class_3222 serverPlayerEntity) {
        Intrinsics.checkNotNullParameter((Object)serverPlayerEntity, (String)"serverPlayerEntity");
        if (!this.state.isLobbyMode()) {
            return;
        }
        IPlayerHandle player = this.playerManager.forPlayer(serverPlayerEntity);
        BingoTeam bingoTeam = this.teamService.getPlayerTeam(player);
        if (bingoTeam == null) {
            return;
        }
        BingoTeam team = bingoTeam;
        BlockPosition blockPosition = this.spawnService.getTeamSpawnpoint(team);
        if (blockPosition == null || (blockPosition = blockPosition.toBlockPos()) == null) {
            return;
        }
        BlockPosition spawn = blockPosition;
        IServerWorld dimension = this.spawnService.getSpawnDimension();
        player.setSpawnPoint(dimension, BlockPosition.Companion.fromBlockPos((class_2338)spawn), 0.0f, true, false);
    }

    private static final Unit _init_$lambda$0(ScopeStopped it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        instance = null;
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0006J\r\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\u0006J\u000f\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\u0006J\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011R$\u0010\u0013\u001a\u0004\u0018\u00010\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lme/jfenn/bingo/mixinhandler/PlayerManagerMixinHelper$Companion;", "", "<init>", "()V", "", "exists", "()Z", "shouldPreventLobbyChaos", "shouldSpawnInLobby", "Lme/jfenn/bingo/common/spawn/SpawnData;", "getPregameSpawnData", "()Lme/jfenn/bingo/common/spawn/SpawnData;", "shouldOverrideEndRespawn", "Lnet/minecraft/class_3222;", "player", "", "setPlayerSpawnpoint", "(Lnet/minecraft/class_3222;)V", "Lme/jfenn/bingo/mixinhandler/PlayerManagerMixinHelper;", "instance", "Lme/jfenn/bingo/mixinhandler/PlayerManagerMixinHelper;", "getInstance", "()Lme/jfenn/bingo/mixinhandler/PlayerManagerMixinHelper;", "setInstance", "(Lme/jfenn/bingo/mixinhandler/PlayerManagerMixinHelper;)V", "bingo-common"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PlayerManagerMixinHelper getInstance() {
            return instance;
        }

        public final void setInstance(@Nullable PlayerManagerMixinHelper playerManagerMixinHelper) {
            instance = playerManagerMixinHelper;
        }

        public final boolean exists() {
            return this.getInstance() != null;
        }

        public final boolean shouldPreventLobbyChaos() {
            PlayerManagerMixinHelper playerManagerMixinHelper = this.getInstance();
            return playerManagerMixinHelper != null ? playerManagerMixinHelper.shouldPreventLobbyChaos() : false;
        }

        public final boolean shouldSpawnInLobby() {
            PlayerManagerMixinHelper playerManagerMixinHelper = this.getInstance();
            return playerManagerMixinHelper != null ? playerManagerMixinHelper.shouldSpawnInLobby() : false;
        }

        @Nullable
        public final SpawnData getPregameSpawnData() {
            PlayerManagerMixinHelper playerManagerMixinHelper = this.getInstance();
            return playerManagerMixinHelper != null ? playerManagerMixinHelper.getPregameSpawnData() : null;
        }

        public final boolean shouldOverrideEndRespawn() {
            PlayerManagerMixinHelper playerManagerMixinHelper = this.getInstance();
            return playerManagerMixinHelper != null ? playerManagerMixinHelper.shouldOverrideEndRespawn() : false;
        }

        public final void setPlayerSpawnpoint(@NotNull class_3222 player) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                PlayerManagerMixinHelper playerManagerMixinHelper = this.getInstance();
                if (playerManagerMixinHelper == null) break block0;
                playerManagerMixinHelper.setPlayerSpawnpoint(player);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

