package main.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;

public class App {
    private static final ContactManager contactManager = new ContactManager();

    public static void main(String[] args) {

        while (true){
            int wybranaOpcja = wyswietlMenu();
            switch (wybranaOpcja){
                case 1:
                    dodajKontakt();
                    break;
                case 2:
                    wyswietlKontakty();
                    break;
                case 3:
                    wyszukajKontakt();
                    break;
                case 4:
                    usunKontakt();
                    break;
                case 5:
                    return;

            }
        }

    }

    // Wyświetla menu główne i zwraca wybrany numer
    public static int wyswietlMenu(){
        while(true) {
            System.out.println("""
                Menu główne:
                [1] Dodaj kontakt
                [2] Wyświetl kontakty
                [3] Wyszukaj Kontakt
                [4] Usuń Kontakt
                [5] Wyjście
                """);

            Scanner scanner = new Scanner(System.in);
            try {
                int wybranyNumer = scanner.nextInt();
                if (wybranyNumer >= 1 && wybranyNumer <= 5) {
                    return wybranyNumer;
                } else {
                    System.out.println("Nieprawidłowy numer");
                }
            } catch (Exception e) {
                System.out.println("Nieprawidłwy numer");
            }
        }
    }

    public static void dodajKontakt(){
        Scanner scanner = new Scanner(System.in);
        String firstname;
        String lastname;
        String phonenumber;
        String email;
        System.out.println("Dodawanie Kontaktu:\n" +
                "Podaj imie:");
        firstname = scanner.nextLine();
        System.out.println("Podaj nazwisko:");
        lastname = scanner.nextLine();
        System.out.println("Podaj Numer Telefonu:");
        phonenumber = scanner.nextLine();
        System.out.println("Podaj email:");
        email = scanner.nextLine();

        int indexDodanegoKontaktu = contactManager.dodajKontakt(firstname, lastname, phonenumber, email);

        System.out.println("Dodano kontakt do listy:");
        contactManager.wyswietlKontakt(indexDodanegoKontaktu);
        System.out.println("\n");
    }
    public static void wyswietlKontakty( ){
        System.out.println("Kontakty:\n");
        contactManager.wyswietlWszystkieKontakty();
    }
    public static void wyszukajKontakt( ){
        Scanner scanner = new Scanner(System.in);
        System.out.print("Podaj wyszukiwane nazwisko: ");
        ArrayList<Integer> znalezioneKontakty = contactManager.znajdzKontaktyPoNazwisku(scanner.nextLine());
        znalezioneKontakty.forEach(index -> {
            contactManager.wyswietlKontakt(index);
        });
    }
    public static void usunKontakt( ){
        while(true) {
            Scanner scanner = new Scanner(System.in);
            System.out.print("Podaj numer telefonu do usunięcia albo 0 aby wyjść: ");
            String input = scanner.nextLine();
            try{
                if (input.matches("0")) return;
                if (!input.matches("[0-9]")) {
                    int index = contactManager.znajdzKontaktPoNumerzeTelefonu(input);
                    System.out.println("Usuwanie kontaktu:");
                    contactManager.wyswietlKontakt(index);
                    contactManager.usunKontakt(index);
                    System.out.println("Usunięto kontakt");
                    return;
                } else {
                    System.out.println("Nieprawidłowy numer");
                }
            } catch (Exception e){
                System.out.println("Nieprawidłowy numer");
            }
        }
    }
}
