package main.java;

import java.util.ArrayList;
import java.util.HashMap;

public class ContactManager {
    private ArrayList<Contact> listaKontaktow = new ArrayList<>();
    public ContactManager() {

    }

    // Metoda dodaje kontakt z podanych argumentów a następnie zwraca jego index
    public int dodajKontakt(String firstname, String lastname, String phonenumber, String email){
        listaKontaktow.add(new Contact(firstname, lastname, phonenumber, email));
        return listaKontaktow.size() - 1;
    }

    public void wyswietlKontakt(int index){
        System.out.print(index+1 + ". " + listaKontaktow.get(index).toString() + "\n");
    }

    public void wyswietlWszystkieKontakty(){
        if (listaKontaktow.isEmpty()) {
            System.out.println("Brak kontaktów");
            return;
        }
        int index = 0;
        for (Contact kontakt : listaKontaktow){
            wyswietlKontakt(index);
            index++;
        }
    }

    public void usunKontakt(int index){
        listaKontaktow.remove(index);
    }

    // Zwraca indexy kontaktów pasujące do wyszukiwanej frazy (argument) jako ArrayList<index>
    public ArrayList<Integer> znajdzKontaktyPoNazwisku(String nazwisko){
        ArrayList<Integer> pasujaceKontakty = new ArrayList<>();
        int index = 0;
        for (Contact kontakt : listaKontaktow){
            if (kontakt.getLastName().contains(nazwisko))
            {
                pasujaceKontakty.add(index);
            }
            index++;
        }
        return pasujaceKontakty;
    }

    public int znajdzKontaktPoNumerzeTelefonu(String phonenumber){
        int index = 0;
        for (Contact kontakt : listaKontaktow){
            if (kontakt.getPhoneNumber().matches(phonenumber))
            {
                return index;
            }
            index++;
        }
        return -1;
    }

    public ArrayList<Contact> getListaKontaktow() {
        return listaKontaktow;
    }
}
